<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Landingpage extends CI_Controller
{

	public function index()
	{
		$this->form_validation->set_rules('subscribe', 'subscribe', 'trim');


		if ($this->form_validation->run() == FALSE) {
			$data['umrah'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE b.jenis = 'Umrah' ORDER BY a.id_paket DESC LIMIT 3")->result();
			$data['haji'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE b.jenis = 'Haji' ORDER BY a.id_paket DESC LIMIT 3")->result();
			$data['wisata'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE b.jenis = 'Wisata' ORDER BY a.id_paket DESC LIMIT 3")->result();
			$data['pembimbing'] = $this->db->get('pembimbing_jamaah')->result();
			landingpage('index', $data);
		} else {
			$subscribe = $this->input->post('subscribe');
			$cekData = $this->db->get_where('subscribe', ['alamat_email' => $subscribe])->num_rows();

			if ($cekData > 0) {
				$this->session->set_flashdata('pesan', "<script>alert('alamat email sudah terdaftar di list subcriber kami.')</script>");
				redirect(base_url(''));
			} else {
				$this->db->insert('subscribe', ['alamat_email' => $subscribe]);
				$this->session->set_flashdata('pesan', "<script>alert('Subscribe Berhasil.')</script>");
				redirect(base_url(''));
			}
		}
	}

	public function blog()
	{
		$data['blog'] = $this->db->query("SELECT * FROM blog_posts a LEFT JOIN blog_kategori b ON a.id_blog_kategori = b.id_blog_kategori ORDER BY a.id_blog_posts DESC")->result();
		$data['title'] = 'Semua Blog';
		landingpage('blog/index', $data);
	}

	public function faq()
	{
		$data['title'] = 'Frequently Asked Questions';
		landingpage('fax', $data);
	}

	public function blog_kategori($slug)
	{
		$data['blog'] = $this->db->query("SELECT * FROM blog_posts a LEFT JOIN blog_kategori b ON a.id_blog_kategori = b.id_blog_kategori WHERE b.slug = '$slug' ORDER BY a.id_blog_posts DESC")->result();
		$kategori = $this->db->get_where('blog_kategori', ['slug' => $slug])->row();
		$data['title'] = 'Kategori ' . $kategori->nama_kategori;
		landingpage('blog/index', $data);
	}

	public function blog_detail($slug)
	{
		$this->db->set('views', 'views+1', FALSE)->where('slug', $slug)->update('blog_posts');
		$data['blog'] = $this->db->query("SELECT * FROM blog_posts a LEFT JOIN blog_kategori b ON a.id_blog_kategori = b.id_blog_kategori WHERE a.slug = '$slug' ORDER BY a.id_blog_posts DESC")->row();
		$data['title'] = 'Detail Blog';
		landingpage('blog/detail', $data);
	}

	public function testimoni()
	{
		$data['testimoni'] = $this->db->query("SELECT * FROM testimoni ORDER BY id_testimoni DESC")->result();
		$data['title'] = 'Video Testimoni';
		landingpage('testimoni/index', $data);
	}

	public function galeri()
	{
		$data['galeri'] = $this->db->query("SELECT * FROM galleri ORDER BY id_galleri DESC")->result();
		$data['title'] = 'Gambar Galeri';
		landingpage('galeri/index', $data);
	}

	public function kontak()
	{
		$data['title'] = 'Kontak Kami';
		landingpage('kontak/index', $data);
	}

	public function alamat()
	{
		$data['title'] = 'Alamat Kantor';
		landingpage('alamat/index', $data);
	}

	public function kategori($slug)
	{
		$categoryCheck = $this->db->get_where('kategori', ['slug' => $slug]);
		if ($categoryCheck->num_rows() > 0) {
			$query = $categoryCheck->row();
			$data['kategori'] = $query;
			$data['paket'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE a.id_kategori = '$query->id_kategori' ORDER BY a.id_paket DESC")->result();
			landingpage('paket/kategori', $data);
		} else {
			redirect(base_url(''));
		}
	}

	public function paket($jenis = null)
	{
		if ($jenis != null) {
			$data['paket'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE b.jenis = '" . ucwords($jenis) . "' ORDER BY a.id_paket DESC")->result();
			$data['title'] = 'Paket ' . ucwords($jenis);
		} else {
			$data['paket'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori ORDER BY a.id_paket DESC")->result();
			$data['title'] = 'Semua Paket';
		}

		landingpage('paket/index', $data);
	}

	public function detail_paket($slug)
	{
		$dataCheck = $this->db->get_where('paket', ['slug_paket' => $slug]);
		if ($dataCheck->num_rows() > 0) {
			$query = $dataCheck->row();
			$data['paket'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE a.id_paket = '$query->id_paket'")->row();
			landingpage('paket/detail', $data);
		} else {
			redirect(base_url(''));
		}
	}

	public function pesan_paket($slug)
	{
		$paket = $this->db->get_where('paket', ['slug_paket' => $slug])->row();
		$data['id_paket'] = $paket->id_paket;
		$data['harga_booking'] = implode('|', $this->input->post('harga'));
		$data['kamar_booking'] = implode('|', $this->input->post('jenis'));
		$data['total_pax'] = implode('|', $this->input->post('jumlah_pax'));

		$totalPax = 0;
		foreach ($this->input->post('jumlah_pax') as $row) :
			$totalPax += $row;
		endforeach;

		if ($totalPax > (int)$paket->seats) {
			$this->session->set_flashdata('msg', '<div class="row">
            <div class="col-lg-12">
                <div class="alert alert-danger text-center" role="alert">
                    Total Pax Melebihi Seats Tersedia !
                </div>
            </div>
        </div>');
			redirect(base_url('paket/detail/') . $slug);
		} else if ($totalPax > 0) {
			$this->db->set('seats', 'seats-' . $totalPax, FALSE)->where('id_paket', $paket->id_paket)->update('paket');
		} else {
			$this->session->set_flashdata('msg', '<div class="row">
            <div class="col-lg-12">
                <div class="alert alert-danger text-center" role="alert">
                    Total Pax Tidak Boleh 0 !
                </div>
            </div>
        </div>');
			redirect(base_url('paket/detail/') . $slug);
		}

		$data['total_harga'] = $this->input->post('total_harga');
		$query = $this->db->query("SELECT * FROM booking ORDER BY kode_transaksi DESC LIMIT 1");

		if ($query->num_rows() > 0) {
			$last_kode_transaksi = $query->row()->kode_transaksi;
			$sequence_number = (int) str_replace('TRX', "", $last_kode_transaksi) + 1;
			$data['kode_transaksi'] = 'TRX' . str_pad($sequence_number, 6, '0', STR_PAD_LEFT);
		} else {
			$data['kode_transaksi'] = 'TRX000001';
		}

		$this->db->insert('booking', $data);
		redirect(base_url('paket/transaksi/') . $data['kode_transaksi']);
	}

	public function transaksi_paket($kode_transaksi)
	{
		$dataCheck = $this->db->query("SELECT * FROM booking WHERE kode_transaksi = '$kode_transaksi'");
		$dataTrx = $dataCheck->row();
		if ($dataCheck->num_rows() > 0) {
			$data['paket'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE a.id_paket = '$dataTrx->id_paket'")->row();
			$data['query'] = $dataTrx;
			landingpage('paket/transaksi', $data);
		} else {
			redirect(base_url(''));
		}
	}

	public function email_check()
	{
		$alamat_email = $this->input->post('email'); // Mengambil alamat email dari permintaan POST
		// $alamat_email = 'febriyan.hadinata@hit-travel.id'; // Mengambil alamat email dari permintaan POST

		$query = $this->db->get_where('users', ['alamat_email' => $alamat_email])->num_rows();

		if ($query > 0) {
			// Jika alamat email sudah terdaftar, kirim respons JSON 'true'
			$response = true;
			echo json_encode($response);
		} else {
			// Jika alamat email belum terdaftar, kirim respons JSON 'false'
			$response = false;
			echo json_encode($response);
		}
	}

	public function wa_check()
	{
		$whatsapp = $this->input->post('whatsapp'); // Mengambil alamat email dari permintaan POST
		// $alamat_email = 'febriyan.hadinata@hit-travel.id'; // Mengambil alamat email dari permintaan POST

		$query = $this->db->get_where('users', ['whatsapp' => $whatsapp])->num_rows();

		if ($query > 0) {
			// Jika alamat email sudah terdaftar, kirim respons JSON 'true'
			$response = true;
			echo json_encode($response);
		} else {
			// Jika alamat email belum terdaftar, kirim respons JSON 'false'
			$response = false;
			echo json_encode($response);
		}
	}

	public function pesanan_paket($kode_transaksi)
	{
		$session = $this->session->userdata('user_id');

		if ($session == null) {
			$this->form_validation->set_rules('nama', 'nama', 'trim|required', [
				'required' => 'Kolom Nama Wajib di isi.'
			]);
			$this->form_validation->set_rules('gender', 'gender', 'trim');

			$this->form_validation->set_rules('whatsapp', 'whatsapp', 'trim|required|is_unique[users.whatsapp]', [
				'required' => 'Kolom WhatsApp Wajib di isi.',
				'is_unique' => 'No.WhatsApp telah digunakan.'
			]);
			$this->form_validation->set_rules('email', 'email', 'trim|required|is_unique[users.alamat_email]', [
				'required' => 'Kolom Alamat Email Wajib di isi.',
				'is_unique' => 'Alamat Email telah digunakan.'
			]);
		}
		$this->form_validation->set_rules('nama_jamaah[]', 'nama_jamaah', 'trim|required', [
			'required' => 'Kolom Nama Jamaah Wajib di isi.'
		]);
		$this->form_validation->set_rules('jenis_kelamin_jamaah[]', 'jenis_kelamin_jamaah', 'trim|required', [
			'required' => 'Kolom Jenis Kelamin Jamaah Wajib di isi.'
		]);
		$this->form_validation->set_rules('ktp_jamaah[]', 'ktp_jamaah', 'trim|required|is_unique[data_booking.ktp_jamaah]', [
			'required' => 'Kolom KTP Jamaah Wajib di isi.',
			'is_unique' => 'No KTP telah terdaftar.'
		]);
		$this->form_validation->set_rules('catatan', 'catatan', 'trim');

		if ($this->form_validation->run() == FALSE) {
			$this->transaksi_paket($kode_transaksi);
		} else {
			$session = $this->session->userdata("user_id");
			// Jamaah
			$nama_jamaah = $this->input->post('nama_jamaah');
			$harga_jamaah = $this->input->post('harga_jamaah');
			$kamar_jamaah = $this->input->post('kamar_jamaah');
			$jenis_kelamin_jamaah = $this->input->post('jenis_kelamin_jamaah');
			$ktp_jamaah = $this->input->post('ktp_jamaah');
			foreach ($nama_jamaah as $key => $row) {
				$data_jamaah['kode_booking'] = $kode_transaksi;
				$data_jamaah['nama_jamaah'] = $row;
				$data_jamaah['jenis_kelamin_jamaah'] = $jenis_kelamin_jamaah[$key];
				$data_jamaah['ktp_jamaah'] = $ktp_jamaah[$key];
				$data_jamaah['harga_jamaah'] = $harga_jamaah[$key];
				$data_jamaah['kamar_jamaah'] = $kamar_jamaah[$key];

				$this->db->insert('data_booking', $data_jamaah);
			};

			// Booking
			$data_booking['catatan'] = $this->input->post('catatan');

			// User
			if ($session == null) {
				$data_user['nama'] = $this->input->post('nama');
				$data_user['alamat_email'] = $this->input->post('email');
				$data_user['password'] = password_hash('user123', PASSWORD_DEFAULT);
				$data_user['role'] = 'User';
				$data_user['whatsapp'] = $this->input->post('whatsapp');
				$data_user['kode_refferal'] = $this->input->post('kode_refferal');

				$this->db->insert('users', $data_user);

				$users = $this->db->get_where('users', $data_user)->row();
				$this->session->set_userdata('user_id', $users->id_users);
				$data_booking['id_users'] = $users->id_users;
				$id_users = $users->id_users;
				$nama_user = $this->input->post('nama');

				// Notif User Regist
				$notifUserRegistrasi['id_users'] = $id_users;
				$notifUserRegistrasi['judul'] = 'Akun Berhasil di registrasi.';
				$notifUserRegistrasi['pesan'] = 'Default password anda <strong>user123</strong> segera ganti password.';
				$notifUserRegistrasi['url'] = base_url('user/account/password');
				$notifUserRegistrasi['jenis'] = 'account';
				$notifUserRegistrasi['is_read'] = 0;
				$this->db->insert('notifikasi', $notifUserRegistrasi);
			} else {
				$user = $this->db->query("SELECT * FROM users WHERE id_users = '$session'")->row();

				$nama_user = $user->nama;
				$data_booking['id_users'] = $session;
				$id_users = $session;
			}
			// Notif User Pesan Paket
			$notifUserPesanPaket['id_users'] = $id_users;
			$notifUserPesanPaket['judul'] = 'Paket dipesan.';
			$notifUserPesanPaket['pesan'] = 'Anda berhasil memesan paket silahkan ikuti langkah selanjutnya.';
			$notifUserPesanPaket['url'] = base_url('user/paket/detail/') . $kode_transaksi;
			$notifUserPesanPaket['jenis'] = 'pesan';
			$notifUserPesanPaket['is_read'] = 0;
			$this->db->insert('notifikasi', $notifUserPesanPaket);

			$this->db->where('kode_transaksi', $kode_transaksi);
			$this->db->update('booking', $data_booking);

			// Notif Superadmin
			$superadmin = $this->db->get_where('users', ['id_users' => 1])->row();

			$notifSAPesanPaket['id_users'] = $superadmin->id_users;
			$notifSAPesanPaket['judul'] = $nama_user . ' Memesan Paket.';
			$notifSAPesanPaket['pesan'] = 'User berhasil memesan paket.';
			$notifSAPesanPaket['url'] = base_url('admin/booking/detail/') . $kode_transaksi;
			$notifSAPesanPaket['jenis'] = 'pesan';
			$notifSAPesanPaket['is_read'] = 0;
			$this->db->insert('notifikasi', $notifSAPesanPaket);

			redirect(base_url('user/paket/detail/') . $kode_transaksi);
		}
	}

	public function pembayaran_paket($kode_transaksi)
	{
		$dataCheck = $this->db->query("SELECT * FROM booking WHERE kode_transaksi = '$kode_transaksi'");
		$booking = $dataCheck->row();

		if ($booking) {
			$data['kode_booking'] = $kode_transaksi;
			$data['paket'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE a.id_paket = '$booking->id_paket'")->row();
			$data['query'] = $booking;
			landingpage('paket/pembayaran', $data);
		} else {
			redirect(base_url(''));
		}
	}

	public function getRemainingTime($id_booking)
	{
		$booking = $this->db->query("SELECT * FROM booking a LEFT JOIN paket b ON a.id_paket = b.id_paket WHERE a.id_booking = '$id_booking'")->row();

		if ($booking) {
			$now = new DateTime();
			$booking_created_at = new DateTime($booking->tanggal_keberangkatan);
			$target_date = $booking_created_at->modify('+2 days');
			$interval = $now->diff($target_date);

			$remaining_time = [
				'days' => $interval->days,
				'hours' => $interval->h,
				'minutes' => $interval->i,
				'seconds' => $interval->s,
			];

			echo json_encode($remaining_time);
		} else {
			echo json_encode(['error' => 'Booking not found']);
		}
	}

	public function bayar_paket($kode_transaksi)
	{
		$dataCheck = $this->db->query("SELECT * FROM booking WHERE kode_transaksi = '$kode_transaksi'");
		$query = $dataCheck->row();
		$data['bank_asal'] = $this->input->post('bank_asal');
		$data['no_rekening_asal'] = $this->input->post('no_rekening_asal');
		$data['nama_rekening_asal'] = $this->input->post('nama_rekening_asal');
		$data['nama_cabang_asal'] = $this->input->post('nama_cabang_asal');
		$data['id_bank'] = $this->input->post('id_bank');
		$data['jumlah_pembayaran'] = $this->input->post('jumlah_pembayaran');
		$data['waktu_pembayaran'] = $this->input->post('waktu_pembayaran');
		$data['distribusi_pembayaran'] = $this->input->post('distribusi_pembayaran');
		$data['status'] = 0;
		$data['kode_transaksi'] = $kode_transaksi;

		if ($data['distribusi_pembayaran'] == '1') {

			$data['id_data_booking'] = implode('|', $this->input->post('id_data_booking'));
			$data['nominal_distribusi'] = implode('|', $this->input->post('nominal_distribusi'));

			$dist = $this->input->post('nominal_distribusi');
			$totalDistribusi = 0;
			foreach ($dist as $row) :
				$totalDistribusi += $row;
			endforeach;
			if ($totalDistribusi != $data['jumlah_pembayaran']) {
				$this->session->set_flashdata('gagal', '<div class="row">
			<div class="col-lg-12">
				<div class="alert alert-danger text-center" role="alert">Periksa Kembali Jumlah Pembayaran dan Hitung Kembali Total Nominal Distribusi Pembayaran.</div>
			</div>
		</div>');

				redirect(base_url('paket/pembayaran/') . $kode_transaksi);
			}
		} else {
			$data['id_data_booking'] = null;
			$data['nominal_distribusi'] = null;
		}
		$data['catatan_pembayaran'] = $this->input->post('catatan_pembayaran');

		$bukti_pembayaran = $_FILES['bukti_pembayaran']['name'];

		if ($bukti_pembayaran != null) {
			$config['upload_path'] = './public/images/pembayaran';
			$config['allowed_types'] = 'jpg|jpeg|png|pdf';
			$config['overwrite']  = TRUE;
			$config['encrypt_name'] = TRUE;

			$this->load->library('upload', $config);

			if (!$this->upload->do_upload('bukti_pembayaran')) {
				$error = array('error' => $this->upload->display_errors());
				print_r($error);
				die;
			} else {
				$data['bukti_pembayaran'] = $this->upload->data('file_name');
			}
		}

		$session = $this->session->userdata('user_id');

		$notifUserRegistrasi['id_users'] = $session;
		$notifUserRegistrasi['judul'] = 'Pembayaran Pending.';
		$notifUserRegistrasi['pesan'] = 'Pembayaran Anda Sedang di Tinjau oleh Operator.';
		$notifUserRegistrasi['url'] = base_url('user/paket/detail/') . $kode_transaksi;
		$notifUserRegistrasi['jenis'] = 'bayar_pending';
		$notifUserRegistrasi['is_read'] = 0;
		$this->db->insert('notifikasi', $notifUserRegistrasi);

		$this->db->insert('pembayaran', $data);
		$this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Pembayaran berhasil ditambahkan.',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
		redirect(base_url('user/paket/detail/') . $kode_transaksi);
	}
}
