<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Blog extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        dua();
    }

    public function index()
    {
        $data['title'] = 'Blog Posts';
        $data['page'] = 'Blog';
        admin('blog/index', $data);
    }

    public function data()
    {
        $query = $this->db->query("SELECT * FROM blog_posts a LEFT JOIN blog_kategori b ON a.id_blog_kategori = b.id_blog_kategori ORDER BY a.id_blog_posts DESC")->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $row->DT_RowIndex = $DT_RowIndex++;
            $row->judul_blog = $row->judul_blog;
            $row->nama_kategori = $row->nama_kategori;
            $row->views = $row->views;
            $row->blog_created_at = format_indo($row->blog_created_at);
            $row->aksi = '<div class="btn-group">
            <a href="' . base_url('admin/blog/update/' . md5($row->id_blog_posts)) . '" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pen"></i></a>
            <a href="' . base_url('admin/blog/delete/' . $row->id_blog_posts) . '" onclick="return confirm(\'Yakin hapus data ini?\')" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></a>
        </div>';
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function add()
    {
        $this->form_validation->set_rules('judul_blog', '', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['title'] = 'Add Blog Post';
            $data['page'] = 'Blog';
            admin('blog/add', $data);
        } else {
            $data['judul_blog'] = $this->input->post('judul_blog');
            $data['slug'] = $this->input->post('slug');
            $data['id_blog_kategori'] = $this->input->post('id_blog_kategori');
            $data['meta_title'] = $this->input->post('meta_title');
            $data['meta_desc'] = $this->input->post('meta_desc');
            $data['thumbnail'] = $this->input->post('thumbnail');
            $data['content'] = str_replace('"', "'", $this->input->post('content'));

            $config['upload_path'] = './public/images/blog';
            $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
            $config['overwrite']  = TRUE;
            $config['encrypt_name'] = TRUE;

            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('thumbnail')) {
                $error = array('error' => $this->upload->display_errors());
                print_r($error);
                die;
            } else {
                $data['thumbnail'] = $this->upload->data('file_name');
            }

            $this->db->insert('blog_posts', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/blog/'));
        }
    }

    public function update($id)
    {
        $this->form_validation->set_rules('judul_blog', '', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['blog'] = $this->db->query("SELECT * FROM blog_posts a LEFT JOIN blog_kategori b ON a.id_blog_kategori = b.id_blog_kategori WHERE md5(a.id_blog_posts) = '$id'")->row();
            $data['title'] = ucwords($this->input->get('jenis'));
            $data['jenis_page'] = $this->input->get('jenis');
            admin('blog/update', $data);
        } else {
            $blog = $this->db->query("SELECT * FROM blog_posts a LEFT JOIN blog_kategori b ON a.id_blog_kategori = b.id_blog_kategori WHERE md5(a.id_blog_posts) = '$id'")->row();
            $data['judul_blog'] = $this->input->post('judul_blog');
            $data['slug'] = $this->input->post('slug');
            $data['id_blog_kategori'] = $this->input->post('id_blog_kategori');
            $data['meta_title'] = $this->input->post('meta_title');
            $data['meta_desc'] = $this->input->post('meta_desc');
            $data['thumbnail'] = $this->input->post('thumbnail');
            $data['content'] = str_replace('"', "'", $this->input->post('content'));

            $thumbnail = $_FILES['thumbnail']['name'];
            if ($thumbnail != null) {
                $config['upload_path'] = './public/images/blog';
                $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
                $config['overwrite']  = TRUE;
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('thumbnail')) {
                    $error = array('error' => $this->upload->display_errors());
                    print_r($error);
                    die;
                } else {
                    $data['thumbnail'] = $this->upload->data('file_name');
                    @unlink('./public/images/blog/' . $blog->thumbnail);
                }
            }

            $this->db->where('id_blog_posts', $blog->id_blog_posts);
            $this->db->update('blog_posts', $data);
            $this->session->set_flashdata('pesan', "
                Swal.fire({
                    type: 'success',
                    title: 'Data Berhasil di edit',
                    text: '',
                    showConfirmButton: false,
                    timer: 2000
                })
            ");
            redirect(base_url('admin/blog/'));
        }
    }

    public function delete($id)
    {
        $blog_posts = $this->db->query("SELECT * FROM blog_posts WHERE id_blog_posts = '$id'")->row();
        @unlink('./public/images/blog/' . $blog_posts->thumbnail);
        $this->db->where('id_blog_posts', $blog_posts->id_blog_posts);
        $this->db->delete('blog_posts');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/blog'));
    }

    public function kategori()
    {
        $data['title'] = 'Kategori';
        admin('blog/kategori', $data);
    }

    public function data_kategori()
    {
        $this->db->select('*');
        $this->db->from('blog_kategori');
        $this->db->order_by('id_blog_kategori', 'desc');
        $query = $this->db->get('')->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $row->DT_RowIndex = $DT_RowIndex++;
            $row->nama_kategori = $row->nama_kategori;
            $row->total_blog = '0';
            $row->aksi = '<div class="btn-group">
            <button onclick="editForm(`' . base_url('admin/blog/update_kategori/' . $row->id_blog_kategori) . '`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pen"></i></button>
            <a href="' . base_url('admin/blog/delete_kategori/' . $row->id_blog_kategori) . '" onclick="return confirm(\'Yakin hapus data ini?\')" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></a>
        </div>';
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function update_kategori($id)
    {
        if ($this->input->post('post') == 'true' || $this->input->post('post') != null) {
            $data['slug'] = $this->input->post('slug');
            $data['nama_kategori'] = $this->input->post('nama_kategori');
            $this->db->where('id_blog_kategori', $id);
            $this->db->update('blog_kategori', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di edit',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/blog/kategori'));
        } else {
            $query = $this->db->get_where('blog_kategori', ['id_blog_kategori' => $id])->row_array();
            echo json_encode($query);
        }
    }

    public function add_kategori()
    {
        $data['slug'] = $this->input->post('slug');
        $data['nama_kategori'] = $this->input->post('nama_kategori');

        $this->db->insert('blog_kategori', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/blog/kategori'));
    }

    public function delete_kategori($id)
    {
        $this->db->where('id_blog_kategori', $id);
        $this->db->delete('blog_kategori');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/blog/kategori'));
    }
}

/* End of file Kategori.php */
