<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Wallet extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        auth("Superadmin");
    }


    public function index()
    {
        $data['title'] = 'Wallet';
        admin('wallet/index', $data);
    }

    public function data()
    {
        $this->db->select('*');
        $this->db->from('wallet');
        $this->db->order_by('id_wallet', 'desc');
        $query = $this->db->get('')->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $row->DT_RowIndex = $DT_RowIndex++;
            $row->jenis_wallet = $row->jenis_wallet;
            $row->nomor_rekening = $row->nomor_rekening;
            $row->nama_rekening = $row->nama_rekening;
            $row->aksi = '<div class="btn-group">
            <button onclick="editForm(`' . base_url('admin/wallet/update/' . $row->id_wallet) . '`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pen"></i></button>
            <a href="' . base_url('admin/wallet/delete/' . $row->id_wallet) . '" onclick="return confirm(\'Yakin hapus data ini?\')" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></a>
        </div>';
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function update($id)
    {
        if ($this->input->post('post') == 'true' || $this->input->post('post') != null) {
            $data['jenis_wallet'] = $this->input->post('jenis_wallet');
            $data['nomor_rekening'] = $this->input->post('nomor_rekening');
            $data['nama_rekening'] = $this->input->post('nama_rekening');
            $this->db->where('id_wallet', $id);
            $this->db->update('wallet', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di edit',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/wallet'));
        } else {
            $query = $this->db->get_where('wallet', ['id_wallet' => $id])->row_array();
            echo json_encode($query);
        }
    }

    public function add()
    {
        $data['jenis_wallet'] = $this->input->post('jenis_wallet');
        $data['nomor_rekening'] = $this->input->post('nomor_rekening');
        $data['nama_rekening'] = $this->input->post('nama_rekening');

        $this->db->insert('wallet', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/wallet'));
    }

    public function delete($id)
    {
        $this->db->where('id_wallet', $id);
        $this->db->delete('wallet');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/wallet'));
    }
}

/* End of file Kategori.php */
