<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Account extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        auth("User");
    }


    public function index()
    {
        $this->form_validation->set_rules('nama', 'nama', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);
        $this->form_validation->set_rules('alamat_email', 'alamat_email', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);
        $this->form_validation->set_rules('whatsapp', 'whatsapp', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);


        if ($this->form_validation->run() == FALSE) {
            $data['title'] = 'Account';
            user('account/index', $data);
        } else {
            $data['nama'] = $this->input->post('nama');
            $data['alamat_email'] = $this->input->post('alamat_email');
            $data['whatsapp'] = $this->input->post('whatsapp');
            $profile = $_FILES['profile']['name'];

            if ($profile != null) {

                $config['upload_path'] = './public/images/profile/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('profile')) {
                    $error = array('error' => $this->upload->display_errors());
                    print_r($error);
                    die;
                } else {
                    $data['profile'] = $this->upload->data('file_name');
                }
            }

            $session = $this->session->userdata('user_id');

            $notifUserProfile['id_users'] = $session;
            $notifUserProfile['judul'] = 'Data Profile di update.';
            $notifUserProfile['pesan'] = 'Profile Anda Berhasil di update';
            $notifUserProfile['url'] = base_url('user/account/');
            $notifUserProfile['jenis'] = 'account';
            $notifUserProfile['is_read'] = 0;
            $this->db->insert('notifikasi', $notifUserProfile);

            $this->db->where('id_users', $session);
            $this->db->update('users', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Profil berhasil di update',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('user/account'));
        }
    }

    public function password()
    {
        $this->form_validation->set_rules('current-password', 'current-password', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);
        $this->form_validation->set_rules('new-password', 'new-password', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);
        $this->form_validation->set_rules('new-password-confirm', 'new-password-confirm', 'trim|required|matches[new-password]', [
            'required' => 'Field Wajib di isi.',
            'matches' => 'Password tidak sesuai.'
        ]);


        if ($this->form_validation->run() == FALSE) {
            $data['title'] = 'Account';
            user('account/password', $data);
        } else {
            $session = $this->session->userdata('user_id');
            $user = $this->db->get_where('users', ['id_users' => $session])->row();
            $password = $this->input->post('current-password');
            $data['password'] = password_hash($this->input->post('new-password'), PASSWORD_DEFAULT);
            // var_dump($user->password); die;



            if (password_verify($password,$user->password)) {
                $notifUserProfile['id_users'] = $session;
                $notifUserProfile['judul'] = 'Data Password di update.';
                $notifUserProfile['pesan'] = 'Password Anda Berhasil di update';
                $notifUserProfile['url'] = base_url('user/account/password');
                $notifUserProfile['jenis'] = 'account';
                $notifUserProfile['is_read'] = 0;
                $this->db->insert('notifikasi', $notifUserProfile);

                $this->db->where('id_users', $session);
                $this->db->update('users', $data);

                $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Password berhasil di update',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
                redirect(base_url('user/account/password'));
            } else {
                $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'warning',
                title: 'Password lama tidak sesuai',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
                redirect(base_url('user/account/password'));
            }
        }
    }
}

/* End of file Account.php */
