<?php

function admin($path, $data = null)
{
    $ci = &get_instance();
    $session = $ci->session->userdata("user_id");
    $data['users'] = $ci->db->get_where('users', ['id_users' => $session])->row_array();
    $ci->load->view('admin/templates/head', $data);
    $ci->load->view('admin/templates/sidebar', $data);
    $ci->load->view("admin/" . $path, $data);
    $ci->load->view('admin/templates/footer', $data);
}

function agen($path, $data = null)
{
    $ci = &get_instance();
    $session = $ci->session->userdata("user_id");
    $data['users'] = $ci->db->get_where('users', ['id_users' => $session])->row_array();
    $ci->load->view('agen/templates/head', $data);
    $ci->load->view('agen/templates/sidebar', $data);
    $ci->load->view("agen/" . $path, $data);
    $ci->load->view('agen/templates/footer', $data);
}

function user($path, $data = null)
{
    $ci = &get_instance();
    $session = $ci->session->userdata("user_id");
    $data['users'] = $ci->db->get_where('users', ['id_users' => $session])->row_array();
    $ci->load->view('user/templates/head', $data);
    $ci->load->view('user/templates/sidebar', $data);
    $ci->load->view("user/" . $path, $data);
    $ci->load->view('user/templates/footer', $data);
}

function landingpage($path, $data = null)
{
    $ci = &get_instance();
    $session = $ci->session->userdata("user_id");
    if($session != null){
        $data['users'] = $ci->db->get_where('users', ['id_users' => $session])->row_array();
    } else {
        $data['users'] = null;
    }
    
    $ci->load->view('landingpage/templates/head', $data);
    $ci->load->view("landingpage/" . $path, $data);
    $ci->load->view('landingpage/templates/footer', $data);
}

function authentication($path, $data = null)
{
    $ci = &get_instance();
    $ci->load->view('auth/templates/head');
    $ci->load->view("auth/" . $path, $data);
    $ci->load->view('auth/templates/footer');
}

function login()
{
    $ci = get_instance();
    $session = $ci->session->userdata("user_id");
    $session = $ci->db->get_where('users', ['id_users' => $session])->row_array();
    if ($session && $session["role"] == "Superadmin") {
        redirect("admin/dashboard");
    } else if ($session && $session["role"] == "Admin") {
        redirect("admin/dashboard");
    } else if ($session && $session["role"] == "Agen") {
        redirect("agen/dashboard");
    } else if ($session && $session["role"] == "User") {
        redirect("user/dashboard");
    }
}

function auth($auth)
{
    $ci = get_instance();
    $session = $ci->session->userdata("user_id");
    $session = $ci->db->get_where('users', ['id_users' => $session])->row_array();
    if (empty($session)) {
        redirect(base_url("auth"));
    } else {
        if ($session["role"] != $auth) {
            redirect(base_url("auth"));
        }
    }
}

function dua()
{
    $ci = get_instance();
    $session = $ci->session->userdata("user_id");
    $session = $ci->db->get_where('users', ['id_users' => $session])->row_array();
    if (empty($session)) {
        redirect(base_url("auth"));
    } else {
        if ($session["role"] == "Superadmin" || $session["role"] == "Admin") {
        } else {
            redirect(base_url("auth"));
        }
    }
}
