<?php
if ($booking->jenis == 'Haji' || $booking->jenis == 'Umrah') {
    $jenis = 'hajiumrah';
} else {
    $jenis = 'wisata';
}

$dataPembayaran = $this->db->where(['kode_transaksi' => $booking->kode_transaksi])->order_by('id_pembayaran', 'DESC')->get('pembayaran')->result();
$jamaah = $this->db->get_where('data_booking', ['kode_booking' => $booking->kode_transaksi])->result();
$kelengkapan = $this->db->get_where('kelengkapan', ['jenis' => $jenis])->result();
$dokumen = $this->db->get_where('dokumen', ['jenis' => $jenis])->result();
$dataSuccess = $this->db->get_where('pembayaran', ['kode_transaksi' => $booking->kode_transaksi, 'status' => 1, 'distribusi_pembayaran' => 1])->result();
$dataSuccessDistribusi = $this->db->get_where('pembayaran', ['kode_transaksi' => $booking->kode_transaksi, 'status' => 1, 'distribusi_pembayaran' => 0])->result();
$totalPD = 0;
$distribusiNums = 0;
foreach ($dataSuccess as $row) :
    $totalPD += $row->jumlah_pembayaran;
endforeach;
foreach ($dataSuccessDistribusi as $row) :
    $distribusiNums += $row->jumlah_pembayaran;
endforeach;
$tpax = explode('|', $booking->total_pax);
$ttlPax = 0;
foreach ($tpax as $row) :
    $ttlPax += $row;
endforeach;
$distribusiNum = $distribusiNums * $ttlPax;
$totalPD = $distribusiNum + $totalPD;
$totalHarga = $booking->total_harga;
$totalKekurangan = $totalHarga - $totalPD;
$persentasePembayaran = ($totalPD / $totalHarga) * 100;
?>
<div class="row">
    <div class="col-12">
        <div class="card-box">
            <div class="row">
                <div class="col-12">
                    <ul class="sortable-list list-unstyled taskList" id="upcoming">
                        <li>
                            <div class="row">
                                <div class="col-3">
                                    <small>KODE TRANSAKSI</small>
                                    <p><strong><?= $booking->kode_transaksi ?></strong></p>
                                </div>
                                <div class="col-3">
                                    <small>WAKTU BOOKING</small>
                                    <p><strong><?= format_indo($booking->booking_created_at) ?></strong></p>
                                </div>
                                <div class="col-3">
                                    <small>STATUS TRANSAKSI</small>
                                    <p><strong>
                                            <?php
                                            $getsDataPembayaran = $this->db->query("SELECT * FROM pembayaran WHERE kode_transaksi = '$booking->kode_transaksi' AND status='1'")->result();
                                            if ($getsDataPembayaran != null) {
                                                $totalPembayarans = 0;
                                                foreach ($getsDataPembayaran as $dataPembayarans) {
                                                    $totalPembayarans += $dataPembayarans->jumlah_pembayaran;
                                                }
                                                if ($totalPembayarans >= $booking->total_harga) {
                                                    echo 'Lunas';
                                                } elseif ($totalPembayarans <= $booking->total_harga) {
                                                    echo 'Belum Lunas';
                                                }
                                            } else {
                                                echo 'Menunggu Pembayaran';
                                            }
                                            ?>
                                        </strong></p>
                                </div>
                                <div class="col-3">
                                    <small>JATUH TEMPO PEMBAYARAN</small>
                                    <p><strong><?= format_indo($booking->booking_created_at) ?></strong></p>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <?php
                    if ($dataPembayaran == null) {
                    ?>
                        <div class="alert alert-warning alert-dismissable text-center">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            Transaksi belum selesai. Pembayaran awal Anda sedang menunggu proses konfirmasi dari sistem/operator.
                        </div>
                    <?php
                    }
                    ?>
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a href="#transaksi" data-toggle="tab" aria-expanded="false" class="nav-link active">
                                <span class="d-block d-sm-none"><i class="fas fa-home"></i></span>
                                <span class="d-none d-sm-block">Transaksi</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#daftar-jamaah" data-toggle="tab" aria-expanded="true" class="nav-link">
                                <span class="d-block d-sm-none"><i class="far fa-user"></i></span>
                                <span class="d-none d-sm-block">Daftar Jamaah</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#penyerahan-dokumen" data-toggle="tab" aria-expanded="false" class="nav-link">
                                <span class="d-block d-sm-none"><i class="far fa-envelope"></i></span>
                                <span class="d-none d-sm-block">Penyerahan Dokumen</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#penerimaan-kelengkapan" data-toggle="tab" aria-expanded="false" class="nav-link">
                                <span class="d-block d-sm-none"><i class="fas fa-cog"></i></span>
                                <span class="d-none d-sm-block">Penerimaan Kelengkapan</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#pembayaran" data-toggle="tab" aria-expanded="false" class="nav-link">
                                <span class="d-block d-sm-none"><i class="fas fa-cog"></i></span>
                                <span class="d-none d-sm-block">Pembayaran</span>
                            </a>
                        </li>
                    </ul>

                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane fade show active" id="transaksi">
                            <table class="table table-striped">
                                <tr>
                                    <th style="width: 20% !important;">Nama Referensi</th>
                                    <td>[JMH<?= tambah_nol_didepan($users['id_users'], 5) ?>] <?= $users['nama'] ?></td>
                                </tr>
                                <tr>
                                    <th style="width: 20% !important;">Kantor Pelayanan</th>
                                    <td>HIT Travel</td>
                                </tr>
                                <tr>
                                    <th style="width: 20% !important;">Jenis Paket</th>
                                    <td><?= $booking->judul_paket ?></td>
                                </tr>
                                <tr>
                                    <th style="width: 20% !important;">Bandara Keberangkatan</th>
                                    <td><?= $booking->bandara_keberangkatan ?></td>
                                </tr>
                                <tr>
                                    <th style="width: 20% !important;">Tanggal Keberangkatan</th>
                                    <td><?= format_indo($booking->tanggal_keberangkatan) ?></td>
                                </tr>
                                <tr>
                                    <th style="width: 20% !important;">Harga Paket & Kombinasi Kamar</th>
                                    <td>
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Jenis Kamar</th>
                                                    <th>Harga Paket/Pax</th>
                                                    <th>Jumlah Pax</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $kamar_booking = explode('|', $booking->kamar_booking);
                                                $harga_booking = explode('|', $booking->harga_booking);
                                                $total_pax = explode('|', $booking->total_pax);
                                                foreach ($kamar_booking as $key => $row) :
                                                ?>
                                                    <tr>
                                                        <td><?= $row  ?></td>
                                                        <td>Rp. <?= number_format($harga_booking[$key], 0, '.', '.')  ?></td>
                                                        <td><?= $total_pax[$key]  ?> Pax</td>
                                                    </tr>
                                                <?php
                                                endforeach;
                                                ?>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <th style="width: 20% !important;">Total Harga</th>
                                    <td>Rp. <?= number_format($booking->total_harga, 0, '.', '.') ?></td>
                                </tr>
                                <tr>
                                    <th style="width: 20% !important;">Catatan</th>
                                    <td>
                                        <?php
                                        if ($booking->catatan != null) {
                                            echo $booking->catatan;
                                        } else {
                                            echo '-';
                                        }

                                        ?>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="daftar-jamaah">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Kode Registrasi</th>
                                        <th>No KTP</th>
                                        <th>Nama Jamaah</th>
                                        <th>Jenis Kelamin</th>
                                        <th>Jenis Kamar</th>
                                        <th>Total Harga</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    foreach ($jamaah as $row) :
                                    ?>
                                        <tr>
                                            <td>JMH<?= tambah_nol_didepan($row->id_data_booking, 5) ?></td>
                                            <td><?= $row->ktp_jamaah ?></td>
                                            <td><?= $row->nama_jamaah ?></td>
                                            <td><?= $row->jenis_kelamin_jamaah ?></td>
                                            <td><?= $row->kamar_jamaah ?></td>
                                            <td>Rp. <?= number_format($row->harga_jamaah, 0, ".", ".") ?></td>
                                        </tr>
                                    <?php
                                    endforeach;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="penyerahan-dokumen">
                            <div class="flex-wrap">
                                <table class="table table-striped table-hover mb5 nowrap table-sticky-first-last">
                                    <thead>
                                        <tr>
                                            <th>Kode Registrasi</th>
                                            <th>Nama</th>
                                            <?php
                                            foreach ($dokumen as $row) :
                                            ?>
                                                <th><?= $row->nama_dokumen ?></th>
                                            <?php
                                            endforeach;

                                            ?>
                                            <th style="display: none;">Opsi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($jamaah as $row) :
                                        ?>
                                            <tr>
                                                <td class="center">
                                                    <a>JMH<?= tambah_nol_didepan($row->id_data_booking, 5) ?></a>
                                                </td>
                                                <td class="center">
                                                    <?= $row->nama_jamaah ?>
                                                </td>
                                                <?php
                                                foreach ($dokumen as $rows) :
                                                    $checkeds = $this->db->query("SELECT * FROM data_dokumen WHERE id_data_booking = '$row->id_data_booking' AND id_dokumen = '$rows->id_dokumen'")->num_rows();
                                                    if ($checkeds > 0) {
                                                        $checked = 'fa fa-check-circle text-success';
                                                    } else {
                                                        $checked = 'fa fa-times-circle text-danger';
                                                    }
                                                ?>
                                                    <td class="center"><i title='Tidak Tersedia' class='<?= $checked ?> title-tip'></i></td>
                                                <?php
                                                endforeach;
                                                ?>
                                                <td style="display: none;">

                                                </td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="penerimaan-kelengkapan">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Kelengkapan</th>
                                        <th>Status</th>
                                        <th>Waktu Penerimaan</th>
                                        <th>Catatan</th>
                                        <th>Operator</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 1;
                                    foreach ($kelengkapan as $row) :
                                        $data_kelengkapan = $this->db->query("SELECT * FROM data_kelengkapan a LEFT JOIN users b ON a.id_operator = b.id_users WHERE a.kode_booking = '$booking->kode_transaksi' AND a.id_kelengkapan = '$row->id_kelengkapan'")->row_array();

                                        if (!empty($data_kelengkapan['id_kelengkapan'])) {
                                            $id_kelengkapan = 'fa fa-check-circle text-success';
                                        } else {
                                            $id_kelengkapan = 'fa fa-times-circle text-danger';
                                        }

                                        if (!empty($data_kelengkapan['waktu_penerimaan'])) {
                                            $waktu_penerimaan = str_replace('T', ' ', $data_kelengkapan['waktu_penerimaan']);
                                            $waktu_penerimaan = format_indo($waktu_penerimaan);
                                        } else {
                                            $waktu_penerimaan = '-';
                                        }

                                        if (!empty($data_kelengkapan['catatan'])) {
                                            $catatan = $data_kelengkapan['catatan'];
                                        } else {
                                            $catatan = '-';
                                        }

                                        if (!empty($data_kelengkapan['id_operator'])) {
                                            $id_operator = $data_kelengkapan['nama'];
                                        } else {
                                            $id_operator = '-';
                                        }
                                    ?>
                                        <tr>
                                            <td><?= $i ?></td>
                                            <td><?= $row->nama_kelengkapan ?></td>
                                            <td class="center"><i title='Tidak Tersedia' class='<?= $id_kelengkapan ?> title-tip'></i></td>
                                            <td><?= $waktu_penerimaan ?></td>
                                            <td><?= $catatan ?></td>
                                            <td><?= $id_operator ?></td>
                                        </tr>
                                    <?php
                                        $i++;
                                    endforeach;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="pembayaran">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Kode Pembayaran</th>
                                        <th>Catatan</th>
                                        <th>Jumlah</th>
                                        <th>Waktu Pembayaran</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if ($dataPembayaran != null) {
                                        foreach ($dataPembayaran as $row) :
                                    ?>
                                            <tr>
                                                <td>PMB<?= tambah_nol_didepan($row->id_pembayaran, 5) ?></td>
                                                <td>
                                                    <?php
                                                    if ($row->catatan_pembayaran != null) {
                                                        echo $row->catatan_pembayaran;
                                                    } else {
                                                        echo '-';
                                                    }
                                                    ?>
                                                </td>
                                                <td>Rp. <?= number_format($row->jumlah_pembayaran, 0, '.', '.') ?></td>
                                                <td><?= format_indo($row->waktu_pembayaran) ?></td>
                                                <td>
                                                    <?php
                                                    if ($row->status == 0) {
                                                    ?>
                                                        <span class="badge bg-warning">Pending</span>
                                                    <?php
                                                    } else if ($row->status == 1) {
                                                    ?>
                                                        <span class="badge bg-success">Berhasil</span>
                                                    <?php
                                                    } else if ($row->status == 2) {
                                                    ?>
                                                        <span class="badge bg-danger">Ditolak</span>
                                                    <?php
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php
                                        endforeach;
                                    } else {
                                        ?>
                                        <tr>
                                            <td colspan="5" class="text-center">Belum ada data Pembayaran</td>
                                        </tr>
                                    <?php
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="2">Total Tagihan Pembayaran</th>
                                        <th colspan="4">Rp. <?= number_format((int)$booking->total_harga, 0, '.', '.') ?></th>
                                    </tr>
                                    <tr>
                                        <th colspan="2">Total Pembayaran Diterima</th>
                                        <th colspan="4">Rp. <?= number_format((int)$totalPD, 0, '.', '.') ?></th>
                                    </tr>
                                    <tr>
                                        <th colspan="2">Total Kekurangan Pembayaran</th>
                                        <th colspan="4">Rp. <?= number_format((int)$totalKekurangan, 0, '.', '.') ?></th>
                                    </tr>
                                    <tr>
                                        <th colspan="2">Total Persentase Pembayaran</th>
                                        <th colspan="4"><?= $persentasePembayaran ?>%</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>