<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Kelengkapan extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['title'] = 'Kelengkapan';
        admin('kelengkapan/index', $data);
    }

    public function data()
    {
        $jenis = $this->input->get('jenis');
        $this->db->select('*');
        $this->db->from('kelengkapan');
        $this->db->order_by('id_kelengkapan', 'desc');
        $this->db->where('jenis', $jenis);
        $query = $this->db->get('')->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $row->DT_RowIndex = $DT_RowIndex++;
            $row->nama_kelengkapan = $row->nama_kelengkapan;
            $row->aksi = '<div class="btn-group">
            <button onclick="editForm(`' . base_url('admin/kelengkapan/update/' . $row->id_kelengkapan) . '?jenis=' . $jenis . '`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pen"></i></button>
            <button onclick="deleteForm(`' . base_url('admin/kelengkapan/delete/' . $row->id_kelengkapan) . '?jenis=' . $jenis . '`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
        </div>';
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function update($id)
    {
        if ($this->input->post('post') == 'true' || $this->input->post('post') != null) {
            $data['jenis'] = $this->input->post('jenis');
            $data['nama_kelengkapan'] = $this->input->post('nama_kelengkapan');
            $this->db->where('id_kelengkapan', $id);
            $this->db->update('kelengkapan', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di edit',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/kelengkapan?jenis=' . $data['jenis']));
        } else {
            $query = $this->db->get_where('kelengkapan', ['id_kelengkapan' => $id])->row_array();
            echo json_encode($query);
        }
    }

    public function add()
    {
        $data['jenis'] = $this->input->post('jenis');
        $data['nama_kelengkapan'] = $this->input->post('nama_kelengkapan');

        $this->db->insert('kelengkapan', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/kelengkapan?jenis=' . $data['jenis']));
    }

    public function delete($id)
    {
        $jenis = $this->input->get('jenis');

        $this->db->where('id_kelengkapan', $id);
        $this->db->delete('kelengkapan');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/kelengkapan?jenis=') . $jenis);
    }

    public function penerimaan()
    {
        $booking = $this->input->get('booking');

        if ($booking != null) {
            $data['booking'] = $this->db->query("SELECT * FROM booking a LEFT JOIN paket b ON a.id_paket = b.id_paket LEFT JOIN kategori c ON b.id_kategori = c.id_kategori WHERE a.kode_transaksi = '$booking'")->row();
            $data['title'] = 'Penerimaan Data Kelengkapan';
            admin('kelengkapan/data_penerimaan', $data);
        } else {
            $data['title'] = 'Penerimaan Kelengkapan';
            admin('kelengkapan/penerimaan', $data);
        }
    }

    public function penyerahan_sistem($kode_booking)
    {
        $booking = $this->db->get_where('booking', ['kode_transaksi' => $kode_booking])->row();
        $paket = $this->db->get_where('paket', ['id_paket' => $booking->id_paket])->row();
        
        $data = $this->input->post('data');
        $waktu_penerimaan = $this->input->post('waktu_penerimaan');
        $catatan = $this->input->post('catatan');
        $operator = $this->input->post('operator');
        
        $this->db->where('kode_booking', $kode_booking);
        $this->db->delete('data_kelengkapan');
        
        $val['kode_booking'] = $kode_booking;
        foreach ($data as $key => $row) :
            $val['id_kelengkapan'] = $data[$key];
            $val['waktu_penerimaan'] = $waktu_penerimaan[$key];
            $val['catatan'] = $catatan[$key];
            $val['id_operator'] = $operator[$key];

            $this->db->insert('data_kelengkapan', $val);
        endforeach;

        $notifPenyerahanDokumen['id_users'] = $booking->id_users;
        $notifPenyerahanDokumen['judul'] = 'Penerimaan Kelengkapan Di Update.';
        $notifPenyerahanDokumen['pesan'] = 'Penerimaan Kelengkapan ' . $paket->judul_paket . 'telah di update.';
        $notifPenyerahanDokumen['url'] = base_url('user/paket/detail/') . $kode_booking;
        $notifPenyerahanDokumen['jenis'] = 'pesan';
        $notifPenyerahanDokumen['is_read'] = 0;
        $this->db->insert('notifikasi', $notifPenyerahanDokumen);

        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Penerimaan Kelengkapan Berhasil di update',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/kelengkapan/penerimaan?booking=' . $kode_booking));
    }
}

/* End of file Kelengkapan.php */
