<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Lanjutan extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        auth("Superadmin");
    }


    public function syaratketentuan()
    {
        $jenis = $this->input->get('jenis');

        $this->form_validation->set_rules('content', '', 'trim');


        if ($this->form_validation->run() == FALSE) {
            if ($jenis == 'hajiumrah') {
                $t = 'Haji Umrah';
            } else {
                $t = 'Wisata';
            }
            $data['thisData'] = $this->db->get_where('setting_paket', ['jenis' => $jenis], 1)->row();
            $data['title'] = 'Syarat Ketentuan ' . $t;
            admin('lanjutan/syaratketentuan', $data);
        } else {
            $data['syaratketentuan'] = str_replace('"', "'", $this->input->post('content'));

            $this->db->where('jenis', $jenis);
            $this->db->update('setting_paket', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di edit',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/lanjutan/syaratketentuan?jenis=') . $jenis);
        }
    }

    public function persyaratanpeserta()
    {
        $jenis = $this->input->get('jenis');

        $this->form_validation->set_rules('content', '', 'trim');


        if ($this->form_validation->run() == FALSE) {
            if ($jenis == 'hajiumrah') {
                $t = 'Haji Umrah';
            } else {
                $t = 'Wisata';
            }
            $data['thisData'] = $this->db->get_where('setting_paket', ['jenis' => $jenis], 1)->row();
            $data['title'] = 'Persyaratan Peserta ' . $t;
            admin('lanjutan/persyaratanpeserta', $data);
        } else {
            $data['persyaratanpeserta'] = str_replace('"', "'", $this->input->post('content'));

            $this->db->where('jenis', $jenis);
            $this->db->update('setting_paket', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di edit',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/lanjutan/persyaratanpeserta?jenis=') . $jenis);
        }
    }
}

/* End of file Dashboard.php */
