<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Withdraw extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        auth('Agen');
    }

    public function index()
    {
        $this->form_validation->set_rules('nominal', '', 'trim');


        if ($this->form_validation->run() == FALSE) {
            $data['history'] = $this->db->get_where('withdraw', ['id_agen' => $this->session->userdata("user_id")])->result();
            
            $data['title'] = 'Withdraw';
            $data['page'] = 'Withdraw';
            agen('withdraw/index', $data);
        } else {
            $data['id_agen'] = $this->session->userdata("user_id");
            $data['nominal'] = $this->input->post('nominal');
            $data['nama_bank'] = $this->input->post('nama_bank');
            $data['nomor_rekening'] = $this->input->post('nomor_rekening');
            $data['nama_rekening'] = $this->input->post('nama_rekening');
            $data['status_withdraw'] = 0;

            $agen = $this->db->get_where('users', ['id_users' => $data['id_agen']])->row();
            if ($data['nominal'] > $agen->saldo) {
                $this->session->set_flashdata('pesan', "<script>alert('Saldo tidak cukup.')</script>");
                redirect(base_url('agen/withdraw'));
            } else {
                $newSaldo['saldo'] = $agen->saldo - $data['nominal'];
                $this->db->where('id_users', $agen->id_users);
                $this->db->update('users', $newSaldo);

                $this->db->insert('withdraw', $data);
                $this->session->set_flashdata('pesan', "<script>alert('Saldo berhasil di tarik, silahkan tunggu persetujuan admin.')</script>");
                redirect(base_url('agen/withdraw'));
            }
        }
    }
}

/* End of file Agen.php */
