<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Auth extends CI_Controller
{

    public function index()
    {
        authentication('login');
    }

    public function forgot()
    {
        $this->form_validation->set_rules('alamat_email', 'alamat_email', 'trim|required', [
            'required' => 'Field Wajib di isi'
        ]);


        if ($this->form_validation->run() == FALSE) {
            authentication('forgot');
        } else {
            $alamat_email = $this->input->post('alamat_email');

            $qCheck = $this->db->get_where('users', ['alamat_email' => $alamat_email]);

            if ($qCheck->num_rows() > 0) {
                $url_reset = base_url('auth/new?email=' . $alamat_email . '&token=' . password_hash($alamat_email, PASSWORD_DEFAULT));
                $data['url'] = $url_reset;
                $config = [
                    'smtp_host' => "smtp.gmail.com",
                    'smtp_port' => 587,
                    'smtp_user' => "fikritugas1@gmail.com",
                    '_smtp_auth' => TRUE,
                    'smtp_pass' => "ebmfzdygpribvgbd",
                    'smtp_crypto' => "tls",
                    'protocol' => "smtp",
                    'mailtype' => "html",
                    'send_multipart' => "dwa",
                    'charset' => "utf-8",
                    'wordwrap' => "TRUE"
                ];
                $this->email->initialize($config);
                $this->email->set_newline("\r\n");
                $this->email->from($alamat_email, "Password Reset");
                $this->email->to($alamat_email);

                $this->email->subject('Link Ganti Password Anda.');
                $message = $this->load->view("auth/email", $data, TRUE);
                $this->email->message($message);

                if ($this->email->send()) {
                    $this->session->set_flashdata('msg', "
                    <script>
                    Swal.fire({
                        type: 'success',
                        title: 'Sukses',
                        text: 'Kami telah mengirim link ke alamat email anda silahkan di cek.',
                        showConfirmButton: false,
                        timer: 2000
                    })
                    </script>
                    ");
                    redirect(base_url('auth/forgot'));
                } else {
                    echo $this->email->print_debugger();
                }
            } else {
                $this->session->set_flashdata('msg', "
                    <script>
                    Swal.fire({
                        type: 'warning',
                        title: 'Gagal',
                        text: 'Alamat Email tidak terdaftar dengan akun mana pun.',
                        showConfirmButton: false,
                        timer: 2000
                    })
                    </script>
                    ");
                redirect(base_url('auth/forgot'));
            }
        }
    }

    public function new()
    {
        $alamat_email = $this->input->get('email');
        $token = $this->input->get('token');

        if (password_verify($alamat_email, $token)) {
            $data['url'] = 'email=' . $alamat_email . '&token=' . $token;
            authentication('new', $data);
        } else {
            $this->session->set_flashdata('msg', "
                    <script>
                    Swal.fire({
                        type: 'warning',
                        title: 'Gagal',
                        text: 'Alamat Email dan Token Tidak Valid.',
                        showConfirmButton: false,
                        timer: 2000
                    })
                    </script>
                    ");
            redirect(base_url('auth/forgot'));
        }
    }

    public function newpass()
    {

        $this->form_validation->set_rules('password', 'password', 'trim');
        $this->form_validation->set_rules('password-conf', 'password-conf', 'trim|matches[password]', [
            'matches' => 'Password Tidak Sesuai.'
        ]);


        if ($this->form_validation->run() == FALSE) {
            $this->new();
        } else {
            $email = $this->input->get('email');
            $data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);

            $this->db->where('alamat_email', $email);
            $this->db->update('users', $data);
            $this->session->set_flashdata('msg', "
                    <script>
                    Swal.fire({
                        type: 'success',
                        title: 'Berhasil',
                        text: 'Password berhasil diganti, silahkan login.',
                        showConfirmButton: false,
                        timer: 2000
                    })
                    </script>
                    ");
            redirect(base_url('auth'));
        }
    }

    public function register()
    {
        authentication('register');
    }

    public function registration()
    {
        $nama = $this->input->post('nama');
        $alamat_email = $this->input->post('alamat_email');
        $whatsapp = $this->input->post('whatsapp');
        $kode_refferal = $this->input->post('kode_refferal');
        $password = password_hash($this->input->post('password'), PASSWORD_DEFAULT);

        $queryEmail = $this->db->get_where('users', array('alamat_email' => $alamat_email));
        $queryWhatsApp = $this->db->get_where('users', array('whatsapp' => $whatsapp));
        if ($queryEmail->num_rows() > 0 && $queryWhatsApp->num_rows() > 0) {
            echo "email-wa";
        } elseif ($queryEmail->num_rows() > 0) {
            echo "email";
        } elseif ($queryWhatsApp->num_rows() > 0) {
            echo 'whatsapp';
        } else {
            $this->db->insert('users', ['nama' => $nama, 'alamat_email' => $alamat_email, 'whatsapp' => $whatsapp, 'password' => $password, 'role' => 'User', 'kode_refferal' => $kode_refferal]);
            $user = $this->db->get_where('users', ['nama' => $nama, 'alamat_email' => $alamat_email, 'whatsapp' => $whatsapp, 'role' => 'User'])->row_array();
            $this->session->set_userdata('user_id', $user['id_users']);

            $notifUserRegistrasi['id_users'] = $user['id_users'];
            $notifUserRegistrasi['judul'] = 'Akun Berhasil di registrasi.';
            $notifUserRegistrasi['pesan'] = 'Default password anda <strong>user123</strong> segera ganti password.';
            $notifUserRegistrasi['url'] = base_url('user/account/password');
            $notifUserRegistrasi['jenis'] = 'account';
            $notifUserRegistrasi['is_read'] = 0;
            $this->db->insert('notifikasi', $notifUserRegistrasi);
            echo 'success';
        }
    }

    public function register_agen()
    {
        authentication('register_agen');
    }

    public function agenreg()
    {
        $nama = $this->input->post('nama');
        $alamat_email = $this->input->post('alamat_email');
        $whatsapp = $this->input->post('whatsapp');
        $password = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
        $kode_refferal = $this->generateRandomString();

        $queryEmail = $this->db->get_where('users', array('alamat_email' => $alamat_email));
        $queryWhatsApp = $this->db->get_where('users', array('whatsapp' => $whatsapp));

        if ($queryEmail->num_rows() > 0 && $queryWhatsApp->num_rows() > 0) {
            echo "email-wa";
        } elseif ($queryEmail->num_rows() > 0) {
            echo "email";
        } elseif ($queryWhatsApp->num_rows() > 0) {
            echo 'whatsapp';
        } else {
            $this->db->insert('users', ['nama' => $nama, 'alamat_email' => $alamat_email, 'whatsapp' => $whatsapp, 'password' => $password, 'role' => 'Agen', 'kode_refferal' => $kode_refferal, 'saldo' => 0]);
            $user = $this->db->get_where('users', ['nama' => $nama, 'alamat_email' => $alamat_email, 'whatsapp' => $whatsapp, 'role' => 'Agen', 'kode_refferal' => $kode_refferal, 'saldo' => 0])->row_array();
            $this->session->set_userdata('user_id', $user['id_users']);

            echo 'success';
        }
    }

    public function authenticate()
    {
        $alamat_email = $this->input->post('alamat_email');
        $password = $this->input->post('password');

        $query = $this->db->get_where('users', array('alamat_email' => $alamat_email));

        if ($query->num_rows() > 0) {
            $user = $query->row_array();
            $hashedPassword = $user['password'];

            // Verify the password using password_verify function
            if (password_verify($password, $hashedPassword)) {
                $this->session->set_userdata('user_id', $user['id_users']);
                if ($user['role'] == 'Superadmin') {
                    echo 'Superadmin';
                } elseif ($user['role'] == 'Admin') {
                    echo 'Superadmin';
                } elseif ($user['role'] == 'Agen') {
                    echo 'Agen';
                } elseif ($user['role'] == 'User') {
                    echo 'User';
                }
            } else {
                echo 'error';
            }
        } else {
            echo 'error';
        }
    }

    public function logout()
    {
        $this->session->unset_userdata('user_id');
        redirect(base_url(''));
    }

    function generateRandomString($length = 6)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

/* End of file Auth.php */
