<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Dokumen extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['title'] = 'Dokumen';
        admin('dokumen/index', $data);
    }

    public function data()
    {
        $jenis = $this->input->get('jenis');
        $this->db->select('*');
        $this->db->from('dokumen');
        $this->db->order_by('id_dokumen', 'desc');
        $this->db->where('jenis', $jenis);
        $query = $this->db->get('')->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $row->DT_RowIndex = $DT_RowIndex++;
            $row->nama_dokumen = $row->nama_dokumen;
            $row->aksi = '<div class="btn-group">
            <button onclick="editForm(`' . base_url('admin/dokumen/update/' . $row->id_dokumen) . '?jenis=' . $jenis . '`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pen"></i></button>
            <button onclick="deleteForm(`' . base_url('admin/dokumen/delete/' . $row->id_dokumen) . '?jenis=' . $jenis . '`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
        </div>';
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function update($id)
    {
        if ($this->input->post('post') == 'true' || $this->input->post('post') != null) {
            $data['jenis'] = $this->input->post('jenis');
            $data['nama_dokumen'] = $this->input->post('nama_dokumen');
            $this->db->where('id_dokumen', $id);
            $this->db->update('dokumen', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di edit',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/dokumen?jenis=' . $data['jenis']));
        } else {
            $query = $this->db->get_where('dokumen', ['id_dokumen' => $id])->row_array();
            echo json_encode($query);
        }
    }

    public function penyerahan()
    {
        $booking = $this->input->get('booking');

        if ($booking != null) {
            $data['booking'] = $this->db->query("SELECT * FROM booking a LEFT JOIN paket b ON a.id_paket = b.id_paket LEFT JOIN kategori c ON b.id_kategori = c.id_kategori WHERE a.kode_transaksi = '$booking'")->row();
            $data['title'] = 'Penyerahan Data Dokumen';
            admin('dokumen/data_penyerahan', $data);
        } else {
            $data['title'] = 'Penyerahan Dokumen';
            admin('dokumen/penyerahan', $data);
        }
    }

    public function penyerahan_sistem($kode_booking)
    {
        $booking = $this->db->get_where('booking', ['kode_transaksi' => $kode_booking])->row();
        $paket = $this->db->get_where('paket', ['id_paket' => $booking->id_paket])->row();
        
        $notifPenyerahanDokumen['id_users'] = $booking->id_users;
        $notifPenyerahanDokumen['judul'] = 'Penyerahan Dokumen Di Update.';
        $notifPenyerahanDokumen['pesan'] = 'Penyerahan Dokumen ' . $paket->judul_paket . 'telah di update.';
        $notifPenyerahanDokumen['url'] = base_url('user/paket/detail/') . $kode_booking;
        $notifPenyerahanDokumen['jenis'] = 'pesan';
        $notifPenyerahanDokumen['is_read'] = 0;
        $this->db->insert('notifikasi', $notifPenyerahanDokumen);

        $this->db->where('kode_booking', $kode_booking);
        $this->db->delete('data_dokumen');
        $data['kode_booking'] = $kode_booking;
        $dataMentah = $this->input->post('data');
        foreach ($dataMentah as $row) :
            $explode = explode(',', $row);
            $data['id_data_booking'] = $explode[0];
            $data['id_dokumen'] = $explode[1];
            $this->db->insert('data_dokumen', $data);
        endforeach;
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Penyerahan Dokumen Berhasil di update',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/dokumen/penyerahan?booking=' . $kode_booking));
    }

    public function add()
    {
        $data['jenis'] = $this->input->post('jenis');
        $data['nama_dokumen'] = $this->input->post('nama_dokumen');

        $this->db->insert('dokumen', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/dokumen?jenis=' . $data['jenis']));
    }

    public function delete($id)
    {
        $jenis = $this->input->get('jenis');

        $this->db->where('id_dokumen', $id);
        $this->db->delete('dokumen');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/dokumen?jenis=') . $jenis);
    }
}

/* End of file Dokumen.php */
