<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Galleri extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['title'] = 'Galleri';
        admin('galleri/index', $data);
    }

    public function data()
    {
        $this->db->select('*');
        $this->db->from('galleri');
        $this->db->order_by('id_galleri', 'desc');
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $cardHtml = '<div class="col-md-4 col-xl-4 col-lg-4">
                            <div class="gal-detail thumb">
                                <a href="' . base_url('public/images/galleri/') . $row->images . '" class="image-popup" title="Galleri Jamaah">
                                    <img src="'  . base_url('public/images/galleri/') . $row->images . '" class="thumb-img img-fluid" alt="work-thumbnail">
                                </a>
                                <div class="text-center mt-1">
                                    <button onclick="deleteForm(`' . base_url('admin/galleri/delete/') . $row->id_galleri . '`)" class="btn btn-danger btn-block"><i class="fa fa-trash"></i></button>
                                </div>
                            </div>
                        </div>';
            $data[] = $cardHtml;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }
    
    public function add()
    {
        $config['upload_path'] = './public/images/galleri';
        $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
        $config['overwrite']  = TRUE;
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('images')) {
            $error = array('error' => $this->upload->display_errors());
            print_r($error);
            die;
        } else {
            $data['images'] = $this->upload->data('file_name');
        }
        $this->db->insert('galleri', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/galleri/'));
    }

    public function delete($id)
    {
        $query = $this->db->get_where('galleri', ['id_galleri' => $id])->row();
        @unlink('./public/images/galleri/' . $query->images);

        $this->db->where('id_galleri', $id);
        $this->db->delete('galleri');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/galleri'));
    }
}

/* End of file Galleri.php */
