<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Paket extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function haji()
    {
        $data['title'] = 'Haji';
        $data['page'] = 'haji';
        admin('paket/index', $data);
    }

    public function umrah()
    {
        $data['title'] = 'Umrah';
        $data['page'] = 'umrah';
        admin('paket/index', $data);
    }

    public function wisata()
    {
        $data['title'] = 'Wisata';
        $data['page'] = 'wisata';
        admin('paket/index', $data);
    }

    public function data()
    {
        $jenis = $_GET['jenis'];
        $query = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE b.jenis = '$jenis' ORDER BY a.id_paket DESC")->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $row->DT_RowIndex = $DT_RowIndex++;
            $row->judul_paket = $row->judul_paket;
            $row->program_hari = $row->program_hari;
            $row->seats = $row->seats;
            $row->kategori = $row->nama_kategori;
            $row->aksi = '<div class="btn-group">
            <a href="' . base_url('admin/paket/update/' . md5($row->id_paket) . '?jenis=') . strtolower($jenis) . '" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pen"></i></a>
            <button onclick="deleteForm(`' . base_url('admin/paket/delete/' . $row->id_paket) . '`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
        </div>';
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function update($id)
    {
        $this->form_validation->set_rules('judul_paket', '', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['paket'] = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE md5(a.id_paket) = '$id'")->row();
            $data['title'] = ucwords($this->input->get('jenis'));
            $data['jenis_page'] = $this->input->get('jenis');
            admin('paket/update', $data);
        } else {
            $paket = $this->db->query("SELECT * FROM paket a LEFT JOIN kategori b ON a.id_kategori = b.id_kategori WHERE md5(a.id_paket) = '$id'")->row();
            $data['id_kategori'] = $this->input->post('id_kategori');
            $data['judul_paket'] = $this->input->post('judul_paket');
            $data['slug_paket'] = $this->input->post('slug');
            $data['program_hari'] = $this->input->post('program_hari');
            $data['bandara_keberangkatan'] = $this->input->post('bandara_keberangkatan');
            $data['tanggal_keberangkatan'] = $this->input->post('tanggal_keberangkatan');
            $data['seats'] = $this->input->post('seats');
            $data['fee_agen'] = str_replace('.', "", $this->input->post('fee_agen'));
            $jenis_kamar = implode("|", $this->input->post('jenis_kamar'));
            $data['jenis_kamar'] = str_replace('.', "", $jenis_kamar);
            $harga = implode("|", $this->input->post('harga'));
            $data['harga'] = str_replace('.', "", $harga);

            $data['itinerary'] = str_replace('"', "'", $this->input->post('itinerary'));
            $data['fasilitas'] = str_replace('"', "'", $this->input->post('fasilitas'));

            $thumbnail = $_FILES['thumbnail']['name'];
            if ($thumbnail != null) {
                $config['upload_path'] = './public/images/paket';
                $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
                $config['overwrite']  = TRUE;
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('thumbnail')) {
                    $error = array('error' => $this->upload->display_errors());
                    print_r($error);
                    die;
                } else {
                    $data['thumbnail'] = $this->upload->data('file_name');
                    @unlink('./public/images/paket/' . $paket->thumbnail);
                }
            }

            $data['meta_title'] = $this->input->post('meta_title');
            $data['meta_description'] = $this->input->post('meta_description');

            $this->db->where('id_paket', $paket->id_paket);
            $this->db->update('paket', $data);
            $this->session->set_flashdata('pesan', "
        Swal.fire({
            type: 'success',
            title: 'Data Berhasil di edit',
            text: '',
            showConfirmButton: false,
            timer: 2000
        })
        ");
            redirect(base_url('admin/paket/') . $this->input->get('jenis'));
        }
    }

    public function add()
    {
        $this->form_validation->set_rules('judul_paket', '', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['title'] = 'Paket ' . ucwords($this->input->get('jenis'));
            $data['jenis_page'] = $this->input->get('jenis');
            admin('paket/add', $data);
        } else {
            $data['id_kategori'] = $this->input->post('id_kategori');
            $data['judul_paket'] = $this->input->post('judul_paket');
            $data['slug_paket'] = $this->input->post('slug');
            $data['program_hari'] = $this->input->post('program_hari');
            $data['bandara_keberangkatan'] = $this->input->post('bandara_keberangkatan');
            $data['tanggal_keberangkatan'] = $this->input->post('tanggal_keberangkatan');
            $data['seats'] = $this->input->post('seats');

            $jenis_kamar = implode("|", $this->input->post('jenis_kamar'));
            $data['jenis_kamar'] = str_replace('.', "", $jenis_kamar);
            $harga = implode("|", $this->input->post('harga'));
            $data['harga'] = str_replace('.', "", $harga);
            $data['fee_agen'] = str_replace('.', "", $this->input->post('fee_agen'));
            $data['itinerary'] = str_replace('"', "'", $this->input->post('itinerary'));
            $data['fasilitas'] = str_replace('"', "'", $this->input->post('fasilitas'));

            $config['upload_path'] = './public/images/paket';
            $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
            $config['overwrite']  = TRUE;
            $config['encrypt_name'] = TRUE;

            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('thumbnail')) {
                $error = array('error' => $this->upload->display_errors());
                print_r($error);
                die;
            } else {
                $data['thumbnail'] = $this->upload->data('file_name');
            }

            $data['meta_title'] = $this->input->post('meta_title');
            $data['meta_description'] = $this->input->post('meta_description');

            $this->db->insert('paket', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/paket/') . $this->input->get('jenis'));
        }
    }

    public function delete($id)
    {
        $paket = $this->db->query("SELECT * FROM paket WHERE id_paket = '$id'")->row();
        @unlink('./public/images/paket/' . $paket->thumbnail);
        $this->db->where('id_paket', $paket->id_paket);
        $this->db->delete('paket');
    }
}

/* End of file Haji.php */
