<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Pembayaran extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['pembayaran'] = $this->db->query("SELECT * FROM pembayaran a LEFT JOIN booking b ON a.kode_transaksi = b.kode_transaksi LEFT JOIN paket c ON b.id_paket = c.id_paket LEFT JOIN wallet d ON a.id_bank = d.id_wallet WHERE a.status != '0' ORDER BY a.id_pembayaran DESC")->result();
        $data['title'] = 'Histori Pembayaran';
        admin('pembayaran/index', $data);
    }

    public function pending()
    {
        $data['pembayaran'] = $this->db->query("SELECT * FROM pembayaran a LEFT JOIN booking b ON a.kode_transaksi = b.kode_transaksi LEFT JOIN paket c ON b.id_paket = c.id_paket LEFT JOIN wallet d ON a.id_bank = d.id_wallet WHERE a.status = '0' ORDER BY a.id_pembayaran DESC")->result();
        $data['title'] = 'Pembayaran Pending';
        admin('pembayaran/pending', $data);
    }

    public function action($id)
    {
        if ($this->input->post('post') == 'true' || $this->input->post('post') != null) {
            $data['status'] = $this->input->post('status');
            $getDataPembayaran = $this->db->get_where('pembayaran', ['id_pembayaran' => $id])->row();
            $row = $this->db->get_where('booking', ['kode_transaksi' => $getDataPembayaran->kode_transaksi])->row();
            $getUser = $this->db->get_where('users', ['id_users' => $row->id_users])->row();
            $this->db->where('id_pembayaran', $id);
            $this->db->update('pembayaran', $data);
            if($getUser->kode_refferal != null){
                $getAgen = $this->db->get_where('users', ['kode_refferal' => $getUser->kode_refferal, 'role' => 'Agen'])->row();
                if ($data['status'] == 1) {
                    $getsDataPembayaran = $this->db->query("SELECT * FROM pembayaran WHERE kode_transaksi = '$row->kode_transaksi' AND status='1'")->result();
                    if ($getsDataPembayaran != null) {
                        $totalPembayarans = 0;
                        foreach ($getsDataPembayaran as $dataPembayarans) {
                            $totalPembayarans += $dataPembayarans->jumlah_pembayaran;
                        }
                        if ($totalPembayarans >= $row->total_harga) {
                            $getPaket = $this->db->get_where('paket', ['id_paket' => $row->id_paket])->row();
                            $saldo_agen = $getAgen->saldo;
                            $saldo_agen += $getPaket->fee_agen;
                            $this->db->where('id_users', $getAgen->id_users);
                            $this->db->update('users', ['saldo' => $saldo_agen]);
                        }
                    }
                }
            }
            
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di simpan.',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/pembayaran'));
        } else {
            $query = $this->db->query("SELECT * FROM pembayaran a LEFT JOIN wallet b ON a.id_bank = b.id_wallet WHERE a.id_pembayaran = '$id'")->row_array();
            // echo json_encode($query);
            if ($query['distribusi_pembayaran'] == 0) {
                $distribusi = 'Dibagi Merata';
                $table = '';
            } else {
                $distribusi = 'Dibagi ke Jamaah Tertentu';
                $id_data_booking = explode('|', $query['id_data_booking']);
                $nominal_distribusi = explode('|', $query['nominal_distribusi']);
                $isi = '';
                foreach ($id_data_booking as $key => $row) :
                    $getDataBooking = $this->db->get_where('data_booking', ['id_data_booking' => $row])->row();
                    $nama_jamaah = $getDataBooking->nama_jamaah;

                    $isi .= '<tr>
                <td>'
                        . $nama_jamaah .
                        '</td>
                <td>Rp. '
                        . number_format($nominal_distribusi[$key], 0, '.', '.') .
                        '</td>
                </tr>
                ';
                endforeach;
                $table = '
            <div class="col-12 mb-3">
                            <label for="nama_kategori">Data Distribusi</label><br>
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <td>Nama Jamaah</td>
                                        <td>Nominal</td>
                                    </tr>
                                </thead>
                                <tbody>' .
                    $isi
                    . '</tbody>
                            </table>
                        </div>
            ';
            }
            echo '
            <div class="row">
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Kode Pembayaran</label><br>
                            <strong>PMB' . tambah_nol_didepan($query['id_pembayaran'], 5) . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bank Tujuan</label><br>
                            <strong>' . $query['jenis_wallet'] . ', No: ' . $query['nomor_rekening'] . ', a/n ' . $query['nama_rekening'] . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bank Asal</label><br>
                            <strong>' . $query['bank_asal'] . ', No: ' . $query['no_rekening_asal'] . ', a/n ' . $query['nama_rekening_asal'] . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Jumlah Pembayaran</label><br>
                            <strong>Rp. ' . number_format($query['jumlah_pembayaran'], 0, '.', '.') . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Waktu Pembayaran</label><br>
                            <strong>' . format_indo($query['waktu_pembayaran']) . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Distribusi Pembayaran</label><br>
                            <strong>
                                ' . $distribusi . '
                            </strong>
                        </div>' .
                $table
                . '<div class="col-12 mb-3">
                            <label for="nama_kategori">Catatan Pembayaran</label><br>
                            <strong>
                                ' . $query['catatan_pembayaran'] . '
                            </strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bukti Pembayaran</label><br>
                            <img src="' . base_url('public/images/pembayaran/') . $query['bukti_pembayaran'] . '" height="200px" alt="" srcset="">
                            <input type="hidden" name="post" value="true" />
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Kode Transaksi</label><br>
                            <strong>
                                ' . $query['kode_transaksi'] . '
                            </strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="jenis">Status</label>
                            <select name="status" id="jenis" class="form-control" required>
                                <option value="">- Pilih -</option>
                                <option value="1">Terima</option>
                                <option value="2">Tolak</option>
                            </select>
                        </div>
                    </div>
            ';
        }
    }
}

/* End of file Pembayaran.php */
