<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Promo extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['title'] = 'Promo';
        admin('promo/index', $data);
    }

    public function data()
    {
        $this->db->select('*');
        $this->db->from('promosi');
        $this->db->order_by('id_promosi', 'desc');
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $cardHtml = '<div class="col-md-4 col-xl-4 col-lg-4">
                            <div class="gal-detail thumb">
                                <a href="' . base_url('public/images/promo/') . $row->img . '" class="image-popup" title="Promo Jamaah">
                                    <img src="'  . base_url('public/images/promo/') . $row->img . '" class="thumb-img img-fluid" alt="work-thumbnail">
                                </a>
                                <div class="text-center mt-1">
                                    <button onclick="deleteForm(`' . base_url('admin/promo/delete/') . $row->id_promosi . '`)" class="btn btn-danger btn-block"><i class="fa fa-trash"></i></button>
                                </div>
                            </div>
                        </div>';
            $data[] = $cardHtml;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }
    
    public function add()
    {
        $config['upload_path'] = './public/images/promo';
        $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
        $config['overwrite']  = TRUE;
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('images')) {
            $error = array('error' => $this->upload->display_errors());
            print_r($error);
            die;
        } else {
            $data['img'] = $this->upload->data('file_name');
            $data['url'] = $this->input->post('url');
        }
        $this->db->insert('promosi', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/promo/'));
    }

    public function delete($id)
    {
        $query = $this->db->get_where('promosi', ['id_promosi' => $id])->row();
        @unlink('./public/images/promo/' . $query->img);

        $this->db->where('id_promosi', $id);
        $this->db->delete('promosi');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/promo'));
    }
}

/* End of file Promo.php */
