<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Testimoni extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['title'] = 'Testimoni';
        admin('testimoni/index', $data);
    }

    public function data()
    {
        $this->db->select('*');
        $this->db->from('testimoni');
        $this->db->order_by('id_testimoni', 'desc');
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $cardHtml = '<div class="col-md-4 col-xl-4 col-lg-4 mt-3">
                                <div class="plyr__video-embed plyr-video">
                                    <iframe src="' . $row->embed . '" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                </div>
                                <div class="text-center mt-1">
                                    <button onclick="deleteForm(`' . base_url('admin/testimoni/delete/') . $row->id_testimoni . '`)" class="btn btn-danger btn-block"><i class="fa fa-trash"></i></button>
                                </div>
                        </div>';
            $data[] = $cardHtml;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function add()
    {
        $data['embed'] = $this->input->post('embed');
        $this->db->insert('testimoni', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/testimoni/'));
    }

    public function delete($id)
    {
        $query = $this->db->get_where('testimoni', ['id_testimoni' => $id])->row();

        $this->db->where('id_testimoni', $id);
        $this->db->delete('testimoni');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/testimoni'));
    }
}

/* End of file Testimoni.php */
