<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Users extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        auth("Superadmin");
    }

    public function index()
    {
        $jenis = $this->input->get('data');
        $data['page'] = $jenis;
        $data['title'] = '' . ucwords($jenis);
        $data['usersAccount'] = $this->db->get_where('users', ['role' => ucwords($jenis)])->result();
        admin('users/index', $data);
    }

    function generateRandomString($length = 6) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function add()
    {
        $this->form_validation->set_rules('nama', '', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);
        $this->form_validation->set_rules('alamat_email', '', 'trim|required|is_unique[users.alamat_email]', [
            'required' => 'Field Wajib di isi.',
            'is_unique' => 'Data Alamat Email telah ada di database.'
        ]);
        $this->form_validation->set_rules('password', '', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);
        $this->form_validation->set_rules('whatsapp', '', 'trim|required|is_unique[users.whatsapp]', [
            'required' => 'Field Wajib di isi.',
            'is_unique' => 'Data Nomor Whatsapp telah ada di database.'
        ]);

        if ($this->form_validation->run() == FALSE) {
            $jenis = $this->input->get('data');
            $data['page'] = $jenis;
            $data['title'] = 'Tambahkan ' . ucwords($jenis);
            admin('users/add', $data);
        } else {
            $data['nama'] = $this->input->post('nama');
            $data['alamat_email'] = $this->input->post('alamat_email');
            $data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
            $data['role'] = ucwords($this->input->get('data'));
            $data['whatsapp'] = $this->input->post('whatsapp');

            if($data['role'] == 'Agen'){
                $data['kode_refferal'] = $this->generateRandomString();
                $data['saldo'] = 0;
            }

            $this->db->insert('users', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/users/index?data=') . $this->input->get('data'));
        }
    }

    public function update($ids,$id)
    {
        $this->form_validation->set_rules('nama', '', 'trim|required', [
            'required' => 'Field Wajib di isi.'
        ]);
        $this->form_validation->set_rules('alamat_email', '', 'trim|required|callback_email_check[users.alamat_email]', [
            'required' => 'Field Wajib di isi.',
            'callback_email_check' => 'Data Alamat Email telah ada di database.'
        ]);
        $this->form_validation->set_rules('whatsapp', '', 'trim|required|callback_whatsapp_check[users.whatsapp]', [
            'required' => 'Field Wajib di isi.',
            'callback_whatsapp_check' => 'Data Nomor Whatsapp telah ada di database.'
        ]);

        if ($this->form_validation->run() == FALSE) {
            $jenis = $this->input->get('data');
            $data['page'] = $jenis;
            $data['detail'] = $this->db->query("SELECT * FROM users WHERE md5(id_users) = '$id'")->row();
            $data['title'] = 'Edit ' . ucwords($jenis);
            admin('users/update', $data);
        } else {
            $data['nama'] = $this->input->post('nama');
            $data['alamat_email'] = $this->input->post('alamat_email');
            $data['role'] = ucwords($this->input->get('data'));
            $data['whatsapp'] = $this->input->post('whatsapp');

            $this->db->where('id_users', $ids);
            $this->db->update('users', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data berhasil di update',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/users/index?data=') . $this->input->get('data'));
        }
    }

    public function delete($id, $data){
        $query = $this->db->query("SELECT * FROM users WHERE md5(id_users) = '$id'")->row();
        $this->db->where('id_users', $query->id_users);
        $this->db->delete('users');
        
        $this->session->set_flashdata('pesan', "
        Swal.fire({
            type: 'success',
            title: 'Data berhasil di hapus',
            text: '',
            showConfirmButton: false,
            timer: 2000
        })
        ");
        redirect(base_url('admin/users/index?data=') . $data);
    }

    public function email_check($str)
    {
        $id = $this->uri->segment(4);
        $query = $this->db->query("SELECT * FROM users WHERE alamat_email='$str' AND id_users != '$id'")->num_rows();

        if ($query > 0) {
            $this->form_validation->set_message('email_check', 'Data Alamat Email telah ada di database.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function whatsapp_check($str)
    {
        $id = $this->uri->segment(4);
        
        $query = $this->db->query("SELECT * FROM users WHERE whatsapp='$str' AND id_users != '$id'")->num_rows();

        if ($query > 0) {
            $this->form_validation->set_message('whatsapp_check', 'Data Nomor Whatsapp telah ada di database.');
            return FALSE;
        } else {
            return TRUE;
        }
    }
}
