<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Paket extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        auth("User");
    }

    public function index()
    {
        $session = $this->session->userdata('user_id');
        $data['booking'] = $this->db->query("SELECT * FROM booking a LEFT JOIN paket b ON a.id_paket = b.id_paket WHERE a.id_users = '$session'")->result();
        $data['title'] = 'Detail Booking Paket Umrah';
        user('paket/index', $data);
    }

    public function detail($kode_transaksi)
    {
        $data['booking'] = $this->db->query("SELECT * FROM booking a LEFT JOIN paket b ON a.id_paket = b.id_paket LEFT JOIN kategori c ON b.id_kategori = c.id_kategori WHERE a.kode_transaksi = '$kode_transaksi'")->row();
        $data['title'] = 'Detail Transaksi Paket';
        user('paket/detail', $data);
    }

    public function datajamaah($id_data_booking)
    {
        $this->form_validation->set_rules('nama', '', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['booking'] = $this->db->query("SELECT * FROM data_booking a WHERE md5(a.id_data_booking) = '$id_data_booking'")->row();
            $data['title'] = 'Detail Data Jamaah';
            user('paket/datajamaah', $data);
        } else {
            $booking = $this->db->query("SELECT * FROM data_booking a WHERE md5(a.id_data_booking) = '$id_data_booking'")->row();

            $data['nama_jamaah'] = $this->input->post('nama_jamaah');
            $data['ktp_jamaah'] = $this->input->post('ktp_jamaah');
            $data['jenis_kelamin_jamaah'] = $this->input->post('jenis_kelamin_jamaah');
            $data['tempat_lahir'] = $this->input->post('tempat_lahir');
            $data['tanggal_lahir'] = $this->input->post('tanggal_lahir');
            $data['status'] = $this->input->post('status');
            $data['alamat'] = $this->input->post('alamat');
            $data['provinsi'] = $this->input->post('provinsi');
            $data['kota_kabupaten'] = $this->input->post('kota_kabupaten');
            $data['kecamatan'] = $this->input->post('kecamatan');
            $data['kelurahan'] = $this->input->post('kelurahan');
            $data['hp_jamaah'] = $this->input->post('hp_jamaah');
            $data['area_imigrasi'] = $this->input->post('area_imigrasi');
            $data['area_kemenag'] = $this->input->post('area_kemenag');
            $data['no_paspor'] = $this->input->post('no_paspor');
            $data['tempat_terbit_paspor'] = $this->input->post('tempat_terbit_paspor');
            $data['tgl_terbit_paspor'] = $this->input->post('tgl_terbit_paspor');
            $data['expired_paspor'] = $this->input->post('expired_paspor');
            $data['kebangsaan'] = $this->input->post('kebangsaan');
            $data['nama_di_paspor'] = $this->input->post('nama_di_paspor');

            $foto_paspor = $_FILES['foto_paspor']['name'];
            if ($foto_paspor != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_paspor')) {
                } else {
                    $data['foto_paspor'] = $this->upload->data('file_name');
                }
            }
            $foto_ktp = $_FILES['foto_ktp']['name'];
            if ($foto_ktp != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_ktp')) {
                } else {
                    $data['foto_ktp'] = $this->upload->data('file_name');
                }
            }
            $foto_kk = $_FILES['foto_kk']['name'];
            if ($foto_kk != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_kk')) {
                } else {
                    $data['foto_kk'] = $this->upload->data('file_name');
                }
            }
            $foto_buku_nikah = $_FILES['foto_buku_nikah']['name'];
            if ($foto_buku_nikah != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_buku_nikah')) {
                } else {
                    $data['foto_buku_nikah'] = $this->upload->data('file_name');
                }
            }

            $this->db->where('id_data_booking', $booking->id_data_booking);
            $this->db->update('data_booking', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di simpan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('user/paket/datajamaah/') . $id_data_booking);
        }
    }

    public function datapembayaran($id)
    {
        $query = $this->db->query("SELECT * FROM pembayaran a LEFT JOIN wallet b ON a.id_bank = b.id_wallet WHERE a.id_pembayaran = '$id'")->row_array();
        // echo json_encode($query);
        if ($query['distribusi_pembayaran'] == 0) {
            $distribusi = 'Dibagi Merata';
            $table = '';
        } else {
            $distribusi = 'Dibagi ke Jamaah Tertentu';
            $id_data_booking = explode('|', $query['id_data_booking']);
            $nominal_distribusi = explode('|', $query['nominal_distribusi']);
            $isi = '';
            foreach ($id_data_booking as $key => $row) :
                $getDataBooking = $this->db->get_where('data_booking', ['id_data_booking' => $row])->row();
                $nama_jamaah = $getDataBooking->nama_jamaah;

                $isi .= '<tr>
                <td>'
                    . $nama_jamaah .
                    '</td>
                <td>Rp. '
                    . number_format($nominal_distribusi[$key], 0, '.', '.') .
                    '</td>
                </tr>
                ';
            endforeach;
            $table = '
            <div class="col-12 mb-3">
                            <label for="nama_kategori">Data Distribusi</label><br>
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <td>Nama Jamaah</td>
                                        <td>Nominal</td>
                                    </tr>
                                </thead>
                                <tbody>' .
                $isi
                . '</tbody>
                            </table>
                        </div>
            ';
        }

        if ($query['status'] == 0) {
            $status = '<span class="badge bg-warning">Pending</span>';
        } else if ($query['status'] == 1) {
            $status = '<span class="badge bg-success">Berhasil</span>';
        } else if ($query['status'] == 2) {
            $status = '<span class="badge bg-danger">Ditolak</span>';
        }
        echo '
            <div class="row">
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Kode Pembayaran</label><br>
                            <strong>PMB' . tambah_nol_didepan($query['id_pembayaran'], 5) . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bank Tujuan</label><br>
                            <strong>' . $query['jenis_wallet'] . ', No: ' . $query['nomor_rekening'] . ', a/n ' . $query['nama_rekening'] . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bank Asal</label><br>
                            <strong>' . $query['bank_asal'] . ', No: ' . $query['no_rekening_asal'] . ', a/n ' . $query['nama_rekening_asal'] . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Jumlah Pembayaran</label><br>
                            <strong>Rp. ' . number_format($query['jumlah_pembayaran'], 0, '.', '.') . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Waktu Pembayaran</label><br>
                            <strong>' . format_indo($query['waktu_pembayaran']) . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Distribusi Pembayaran</label><br>
                            <strong>
                                ' . $distribusi . '
                            </strong>
                        </div>' .
            $table
            . '<div class="col-12 mb-3">
                            <label for="nama_kategori">Catatan Pembayaran</label><br>
                            <strong>
                                ' . $query['catatan_pembayaran'] . '
                            </strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bukti Pembayaran</label><br>
                            <img src="' . base_url('public/images/pembayaran/') . $query['bukti_pembayaran'] . '" height="200px" alt="" srcset="">
                            <input type="hidden" name="post" value="true" />
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Kode Transaksi</label><br>
                            <strong>
                                ' . $query['kode_transaksi'] . '
                            </strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="jenis">Status</label>
                            ' . $status . '
                        </div>
                    </div>
            ';
    }

    public function cetak($kode_transaksi)
    {
        $session = $this->session->userdata("user_id");
        $data['users'] = $this->db->get_where('users', ['id_users' => $session])->row();
        $data['booking'] = $this->db->get_where('booking', ['kode_transaksi' => $kode_transaksi])->row();

        $data['pembayaran'] = $this->db->get_where('pembayaran', ['kode_transaksi' => $kode_transaksi, 'status' => 1])->result();

        $this->load->library('pdf');

        // $this->pdf->setPaper('A4', 'landscape');
        // $this->pdf->filename = "rekap-pembayaran-$kode_transaksi.pdf";
        // $this->pdf->load_view('user/paket/cetak', $data, FALSE);

        $this->load->view('user/paket/cetak', $data);
    }
}

/* End of file Paket.php */
