<div class="row">
    <div class="col-md-12">
        <div class="card-box">
            <h4 class="page-title">Saldo : Rp. <?= number_format($users['saldo'], 0, '.', '.') ?></h4>
            <form action="<?= base_url('agen/withdraw') ?>" method="post">
                <div class="form-group row">
                    <div class="col-md-4 mb-2">
                        <label for="nama_bank">Nama Bank</label>
                        <input type="text" required name="nama_bank" class="form-control">
                    </div>
                    <div class="col-md-4 mb-2">
                        <label for="nomor_rekening">Nomor Rekening</label>
                        <input type="text" required name="nomor_rekening" class="form-control">
                    </div>
                    <div class="col-md-4 mb-2">
                        <label for="nama_rekening">Nama Rekening</label>
                        <input type="text" required name="nama_rekening" class="form-control">
                    </div>
                    <div class="col-md-12 mb-2">
                        <label for="">Nominal</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1">Rp.</span>
                            </div>
                            <input type="number" required step="50000" name="nominal" min="50000" class="form-control" aria-label="Nominal WD" aria-describedby="basic-addon1">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <button class="btn btn-primary btn-sm">Withdraw</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="page-title">History Penarikan</h4>
            <table id="datatable" class="table table-bordered dt-responsive nowrap">
                <thead>
                    <tr>
                        <th style="width: 1px;">No</th>
                        <th style="width: auto;">Tanggal dan Waktu</th>
                        <th style="width: auto;">Nominal</th>
                        <th style="width: auto;">Status</th>
                        <th style="width: auto;">Rek Tujuan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 1;

                    foreach ($history as $row) :
                    ?>
                        <tr>
                            <td><?= $i; ?></td>
                            <td><?= format_indo($row->withdraw_created_at); ?></td>
                            <td>Rp. <?= number_format($row->nominal, 0, '.', '.'); ?></td>
                            <td>
                                <?php
                                if($row->status_withdraw == 0){
                                    $status = '<span class="badge badge-warning">Pending<span>';
                                } else if ($row->status_withdraw == 1){
                                    $status = '<span class="badge badge-success">Sukses<span>';
                                } else if ($row->status_withdraw == 2){
                                    $status = '<span class="badge badge-danger">Ditolak<span>';
                                }
                                echo $status;
                                ?>
                            </td>
                            <td><?= $row->nama_bank . ' ' . $row->nomor_rekening . ' ' . $row->nama_rekening; ?></td>
                        </tr>
                    <?php
                        $i++;
                    endforeach;
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>