<?php


defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Booking extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        dua();
    }

    public function haji()
    {
        $data['title'] = 'Haji';
        $data['page'] = 'haji';
        admin('booking/index', $data);
    }

    public function umrah()
    {
        $data['title'] = 'Umrah';
        $data['page'] = 'umrah';
        admin('booking/index', $data);
    }

    public function wisata()
    {
        $data['title'] = 'Wisata';
        $data['page'] = 'wisata';
        admin('booking/index', $data);
    }

    public function data()
    {
        $jenis = $_GET['jenis'];
        $query = $this->db->query("SELECT * FROM booking a LEFT JOIN paket b ON a.id_paket = b.id_paket LEFT JOIN kategori c ON b.id_kategori = c.id_kategori LEFT JOIN users d ON a.id_users = d.id_users WHERE c.jenis = '$jenis' ORDER BY a.id_booking DESC")->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $getDataPembayaran = $this->db->query("SELECT * FROM pembayaran WHERE kode_transaksi = '$row->kode_transaksi' AND status='1'")->result();
            if ($getDataPembayaran != null) {
                $totalPembayaran = 0;
                foreach ($getDataPembayaran as $dataPembayaran) {
                    $totalPembayaran += $dataPembayaran->jumlah_pembayaran;
                }
                if ($totalPembayaran >= $row->total_harga) {
                    $row->status = '<span class="badge badge-success">Lunas</span>';
                } elseif ($totalPembayaran <= $row->total_harga) {
                    $row->status = '<span class="badge badge-warning">Belum Lunas</span>';
                }
            } else {
                $row->status = '<span class="badge badge-danger">Belum ada Pembayaran</span>';
            }
            $totalPax = 0;
            $explodePax = explode('|', $row->total_pax);
            foreach ($explodePax as $pax) :
                $totalPax += $pax;
            endforeach;

            if ($row->nama == null) {
                $row->nama = '<span class="text-danger">Expired</span>';
                $row->aksinya = '<div class="btn-group">
                <a href="' . base_url('admin/booking/delete/' . $row->kode_transaksi) . '?jenis=' . strtolower($jenis) . '" onclick="return confirm(\'Yakin hapus data ini?\')" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></a>
                </div>';
            } else {
                $row->aksinya = '<div class="btn-group">
            <a href="' . base_url('admin/booking/detail/') . $row->kode_transaksi . '" class="btn btn-xs btn-info btn-flat"><i class="fa fa-eye"></i></a>
            <a href="' . base_url('admin/booking/delete/' . $row->kode_transaksi) . '?jenis=' . strtolower($jenis) . '" onclick="return confirm(\'Yakin hapus data ini?\')" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></a>
            </div>';
            }

            $row->DT_RowIndex = $DT_RowIndex++;
            $row->booking_created_at = short_format_indo($row->booking_created_at);
            $row->judul_paket = $row->judul_paket;
            $row->nama = $row->nama;
            $row->total_pax = $totalPax;
            $row->total_harga = 'Rp. ' . number_format($row->total_harga, 0, '.', '.');
            $row->status = $row->status;
            $row->aksi = $row->aksinya;
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function detail($kode_transaksi)
    {
        $data['booking'] = $this->db->query("SELECT * FROM booking a LEFT JOIN paket b ON a.id_paket = b.id_paket LEFT JOIN kategori c ON b.id_kategori = c.id_kategori LEFT JOIN users d ON a.id_users = d.id_users WHERE a.kode_transaksi = '$kode_transaksi'")->row();
        $data['title'] = 'Detail Transaksi Paket';
        admin('booking/detail', $data);
    }

    public function delete($kode_transaksi)
    {
        $query = $this->db->query("SELECT * FROM booking WHERE kode_transaksi = '$kode_transaksi'")->row();
        $totalPax = 0;
        $explodePax = explode('|', $query->total_pax);
        foreach ($explodePax as $pax) {
            $totalPax += $pax;
        }

        $this->db->set('seats', 'seats+' . $totalPax, FALSE)->where('id_paket', $query->id_paket)->update('paket');

        $this->db->where('kode_booking', $query->kode_transaksi);
        $this->db->delete('data_booking');

        $this->db->where('kode_transaksi', $query->kode_transaksi);
        $this->db->delete('pembayaran');

        $this->db->where('id_booking', $query->id_booking);
        $this->db->delete('booking');

        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Booking Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/booking/' . $this->input->get('jenis')));
    }

    public function datajamaah($id_data_booking)
    {
        $this->form_validation->set_rules('nama', '', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['booking'] = $this->db->query("SELECT * FROM data_booking a WHERE md5(a.id_data_booking) = '$id_data_booking'")->row();
            $data['title'] = 'Detail Data Jamaah';
            admin('booking/datajamaah', $data);
        } else {
            $booking = $this->db->query("SELECT * FROM data_booking a WHERE md5(a.id_data_booking) = '$id_data_booking'")->row();

            $data['nama_jamaah'] = $this->input->post('nama_jamaah');
            $data['ktp_jamaah'] = $this->input->post('ktp_jamaah');
            $data['jenis_kelamin_jamaah'] = $this->input->post('jenis_kelamin_jamaah');
            $data['tempat_lahir'] = $this->input->post('tempat_lahir');
            $data['tanggal_lahir'] = $this->input->post('tanggal_lahir');
            $data['status'] = $this->input->post('status');
            $data['alamat'] = $this->input->post('alamat');
            $data['provinsi'] = $this->input->post('provinsi');
            $data['kota_kabupaten'] = $this->input->post('kota_kabupaten');
            $data['kecamatan'] = $this->input->post('kecamatan');
            $data['kelurahan'] = $this->input->post('kelurahan');
            $data['hp_jamaah'] = $this->input->post('hp_jamaah');
            $data['area_imigrasi'] = $this->input->post('area_imigrasi');
            $data['area_kemenag'] = $this->input->post('area_kemenag');
            $data['no_paspor'] = $this->input->post('no_paspor');
            $data['tempat_terbit_paspor'] = $this->input->post('tempat_terbit_paspor');
            $data['tgl_terbit_paspor'] = $this->input->post('tgl_terbit_paspor');
            $data['expired_paspor'] = $this->input->post('expired_paspor');
            $data['kebangsaan'] = $this->input->post('kebangsaan');
            $data['nama_di_paspor'] = $this->input->post('nama_di_paspor');

            $foto_paspor = $_FILES['foto_paspor']['name'];
            if ($foto_paspor != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_paspor')) {
                } else {
                    $data['foto_paspor'] = $this->upload->data('file_name');
                }
            }
            $foto_ktp = $_FILES['foto_ktp']['name'];
            if ($foto_ktp != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_ktp')) {
                } else {
                    $data['foto_ktp'] = $this->upload->data('file_name');
                }
            }
            $foto_kk = $_FILES['foto_kk']['name'];
            if ($foto_kk != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_kk')) {
                } else {
                    $data['foto_kk'] = $this->upload->data('file_name');
                }
            }
            $foto_buku_nikah = $_FILES['foto_buku_nikah']['name'];
            if ($foto_buku_nikah != null) {

                $config['upload_path'] = './public/images/manifest/';
                $config['allowed_types'] = 'jpg|png|jpeg';
                $config['max_size']  = '999999';
                $config['encrypt_name'] = TRUE;

                $this->load->library('upload', $config);

                if (!$this->upload->do_upload('foto_buku_nikah')) {
                } else {
                    $data['foto_buku_nikah'] = $this->upload->data('file_name');
                }
            }

            $this->db->where('id_data_booking', $booking->id_data_booking);
            $this->db->update('data_booking', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di simpan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/booking/datajamaah/') . $id_data_booking);
        }
    }

    public function download($url)
    {
        $file = base_url('public/images/manifest/') . $url;

        header("Content-Description: File Transfer");
        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=\"" . basename($file) . "\"");

        readfile($file);
        exit();
    }

    public function datapembayaran($id)
    {
        $query = $this->db->query("SELECT * FROM pembayaran a LEFT JOIN wallet b ON a.id_bank = b.id_wallet WHERE a.id_pembayaran = '$id'")->row_array();
        // echo json_encode($query);
        if ($query['distribusi_pembayaran'] == 0) {
            $distribusi = 'Dibagi Merata';
            $table = '';
        } else {
            $distribusi = 'Dibagi ke Jamaah Tertentu';
            $id_data_booking = explode('|', $query['id_data_booking']);
            $nominal_distribusi = explode('|', $query['nominal_distribusi']);
            $isi = '';
            foreach ($id_data_booking as $key => $row) :
                $getDataBooking = $this->db->get_where('data_booking', ['id_data_booking' => $row])->row();
                $nama_jamaah = $getDataBooking->nama_jamaah;

                $isi .= '<tr>
                <td>'
                    . $nama_jamaah .
                    '</td>
                <td>Rp. '
                    . number_format($nominal_distribusi[$key], 0, '.', '.') .
                    '</td>
                </tr>
                ';
            endforeach;
            $table = '
            <div class="col-12 mb-3">
                            <label for="nama_kategori">Data Distribusi</label><br>
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <td>Nama Jamaah</td>
                                        <td>Nominal</td>
                                    </tr>
                                </thead>
                                <tbody>' .
                $isi
                . '</tbody>
                            </table>
                        </div>
            ';
        }

        if ($query['status'] == 0) {
            $status = '<span class="badge bg-warning">Pending</span>';
        } else if ($query['status'] == 1) {
            $status = '<span class="badge bg-success">Berhasil</span>';
        } else if ($query['status'] == 2) {
            $status = '<span class="badge bg-danger">Ditolak</span>';
        }
        echo '
            <div class="row">
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Kode Pembayaran</label><br>
                            <strong>PMB' . tambah_nol_didepan($query['id_pembayaran'], 5) . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bank Tujuan</label><br>
                            <strong>' . $query['jenis_wallet'] . ', No: ' . $query['nomor_rekening'] . ', a/n ' . $query['nama_rekening'] . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bank Asal</label><br>
                            <strong>' . $query['bank_asal'] . ', No: ' . $query['no_rekening_asal'] . ', a/n ' . $query['nama_rekening_asal'] . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Jumlah Pembayaran</label><br>
                            <strong>Rp. ' . number_format($query['jumlah_pembayaran'], 0, '.', '.') . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Waktu Pembayaran</label><br>
                            <strong>' . format_indo($query['waktu_pembayaran']) . '</strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Distribusi Pembayaran</label><br>
                            <strong>
                                ' . $distribusi . '
                            </strong>
                        </div>' .
            $table
            . '<div class="col-12 mb-3">
                            <label for="nama_kategori">Catatan Pembayaran</label><br>
                            <strong>
                                ' . $query['catatan_pembayaran'] . '
                            </strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Bukti Pembayaran</label><br>
                            <img src="' . base_url('public/images/pembayaran/') . $query['bukti_pembayaran'] . '" height="200px" alt="" srcset="">
                            <input type="hidden" name="post" value="true" />
                        </div>
                        <div class="col-12 mb-3">
                            <label for="nama_kategori">Kode Transaksi</label><br>
                            <strong>
                                ' . $query['kode_transaksi'] . '
                            </strong>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="jenis">Status</label>
                            ' . $status . '
                        </div>
                    </div>
            ';
    }

    public function laporan()
    {
        $data['paket'] = $this->db->query("SELECT id_paket, judul_paket FROM paket")->result();

        $data['title'] = 'Export Laporan Paket Booking';
        $data['page'] = 'Laporan';
        admin('booking/laporan', $data);
    }

    public function export($id_paket)
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_col = [
            'font' => ['bold' => true], // Set font nya jadi bold
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ],
            'borders' => [
                'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
                'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
                'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
                'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
            ]
        ];
        // Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
        $style_row = [
            'alignment' => [
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ],
            'borders' => [
                'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
                'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
                'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
                'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
            ]
        ];
        $sheet->setCellValue('A1', "DATA JAMAAH"); // Set kolom A1 dengan tulisan "DATA SISWA"
        $sheet->mergeCells('A1:E1'); // Set Merge Cell pada kolom A1 sampai E1
        $sheet->getStyle('A1')->getFont()->setBold(true); // Set bold kolom A1
        // Buat header tabel nya pada baris ke 3
        $sheet->setCellValue('A3', "NO"); // Set kolom A3 dengan tulisan "NO"
        $sheet->setCellValue('B3', "Nama"); // Set kolom A3 dengan tulisan "NO"
        $sheet->setCellValue('C3', "Nama di Paspor"); // Set kolom A3 dengan tulisan "NO"
        $sheet->setCellValue('D3', "Jenis Kelamin"); // Set kolom B3 dengan tulisan "NIS"
        $sheet->setCellValue('E3', "Kebangsaan"); // Set kolom C3 dengan tulisan "NAMA"
        $sheet->setCellValue('F3', "Tempat Lahir"); // Set kolom D3 dengan tulisan "JENIS KELAMIN"
        $sheet->setCellValue('G3', "Tanggal Lahir"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('H3', "No Paspor"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('I3', "Tempat Terbit Paspor"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('J3', "Tanggal Terbit Paspor"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('K3', "Tanggal Expired Paspor"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('L3', "Berkas Paspor"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('M3', "Berkas KTP"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('N3', "Berkas KK"); // Set kolom E3 dengan tulisan "ALAMAT"
        $sheet->setCellValue('O3', "Berkas Buku Nikah"); // Set kolom E3 dengan tulisan "ALAMAT"
        // Apply style header yang telah kita buat tadi ke masing-masing kolom header
        $sheet->getStyle('A3')->applyFromArray($style_col);
        $sheet->getStyle('B3')->applyFromArray($style_col);
        $sheet->getStyle('C3')->applyFromArray($style_col);
        $sheet->getStyle('D3')->applyFromArray($style_col);
        $sheet->getStyle('E3')->applyFromArray($style_col);
        $sheet->getStyle('F3')->applyFromArray($style_col);
        $sheet->getStyle('G3')->applyFromArray($style_col);
        $sheet->getStyle('H3')->applyFromArray($style_col);
        $sheet->getStyle('I3')->applyFromArray($style_col);
        $sheet->getStyle('J3')->applyFromArray($style_col);
        $sheet->getStyle('K3')->applyFromArray($style_col);
        $sheet->getStyle('L3')->applyFromArray($style_col);
        $sheet->getStyle('M3')->applyFromArray($style_col);
        $sheet->getStyle('N3')->applyFromArray($style_col);
        $sheet->getStyle('O3')->applyFromArray($style_col);
        // Panggil function view yang ada di SiswaModel untuk menampilkan semua data siswanya
        $dataBooking = $this->db->query("SELECT * FROM booking WHERE id_paket = '$id_paket' AND id_users != '' ORDER BY id_booking DESC")->result();

        $no = 1; // Untuk penomoran tabel, di awal set dengan 1
        $numrow = 4; // Set baris pertama untuk isi tabel adalah baris ke 4
        foreach ($dataBooking as $booking) { // Lakukan looping pada variabel siswa
            $dataJamaah = $this->db->get_where('data_booking', ['kode_booking' => $booking->kode_transaksi])->result();

            foreach ($dataJamaah as $data) {
                if ($data->foto_paspor != null) {
                    $foto_paspor = "V";
                } else {
                    $foto_paspor = "X";
                }
                if ($data->foto_ktp != null) {
                    $foto_ktp = "V";
                } else {
                    $foto_ktp = "X";
                }
                if ($data->foto_kk != null) {
                    $foto_kk = "V";
                } else {
                    $foto_kk = "X";
                }
                if ($data->foto_buku_nikah != null) {
                    $foto_buku_nikah = "V";
                } else {
                    $foto_buku_nikah = "X";
                }
                $sheet->setCellValue('A' . $numrow, $no);
                $sheet->setCellValue('B' . $numrow, $data->nama_jamaah);
                $sheet->setCellValue('C' . $numrow, $data->nama_di_paspor); // Nama Paspor 
                $sheet->setCellValue('D' . $numrow, $data->jenis_kelamin_jamaah);
                $sheet->setCellValue('E' . $numrow, $data->kebangsaan); // Kebangsaan
                $sheet->setCellValue('F' . $numrow, $data->tempat_lahir);
                $sheet->setCellValue('G' . $numrow, $data->tanggal_lahir);
                $sheet->setCellValue('H' . $numrow, $data->no_paspor);
                $sheet->setCellValue('I' . $numrow, $data->tempat_terbit_paspor);
                $sheet->setCellValue('J' . $numrow, $data->tgl_terbit_paspor);
                $sheet->setCellValue('K' . $numrow, $data->expired_paspor);
                $sheet->setCellValue('L' . $numrow, $foto_paspor);
                $sheet->setCellValue('M' . $numrow, $foto_ktp);
                $sheet->setCellValue('N' . $numrow, $foto_kk);
                $sheet->setCellValue('O' . $numrow, $foto_buku_nikah);

                // Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
                $sheet->getStyle('A' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('B' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('C' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('D' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('E' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('F' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('G' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('H' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('I' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('J' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('K' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('L' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('M' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('N' . $numrow)->applyFromArray($style_row);
                $sheet->getStyle('O' . $numrow)->applyFromArray($style_row);

                $no++; // Tambah 1 setiap kali looping
                $numrow++; // Tambah 1 setiap kali looping
            }
        }
        // Set width kolom
        $sheet->getColumnDimension('A')->setWidth(5); // Set width kolom A
        $sheet->getColumnDimension('B')->setWidth(35); // Set width kolom B
        $sheet->getColumnDimension('C')->setWidth(35); // Set width kolom C
        $sheet->getColumnDimension('D')->setWidth(25); // Set width kolom D
        $sheet->getColumnDimension('E')->setWidth(25); // Set width kolom E
        $sheet->getColumnDimension('F')->setWidth(25); // Set width kolom E
        $sheet->getColumnDimension('G')->setWidth(15); // Set width kolom E
        $sheet->getColumnDimension('H')->setWidth(20); // Set width kolom E
        $sheet->getColumnDimension('I')->setWidth(20); // Set width kolom E
        $sheet->getColumnDimension('J')->setWidth(15); // Set width kolom E
        $sheet->getColumnDimension('K')->setWidth(15); // Set width kolom E
        $sheet->getColumnDimension('L')->setWidth(5); // Set width kolom E
        $sheet->getColumnDimension('M')->setWidth(5); // Set width kolom E
        $sheet->getColumnDimension('N')->setWidth(5); // Set width kolom E
        $sheet->getColumnDimension('O')->setWidth(5); // Set width kolom E

        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $sheet->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $sheet->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
        // Set judul file excel nya
        $sheet->setTitle("Laporan Data Jamaah");
        // Proses file excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="Data Jamaah.xlsx"'); // Set nama file excel nya
        header('Cache-Control: max-age=0');
        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
    }
}

/* End of file Booking.php */
