<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Kategori extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['title'] = 'Kategori';
        admin('kategori/index', $data);
    }

    public function data()
    {
        $this->db->select('*');
        $this->db->from('kategori');
        $this->db->order_by('id_kategori', 'desc');
        $query = $this->db->get('')->result();

        $data = [];
        $DT_RowIndex = 1;
        foreach ($query as $row) {
            $row->DT_RowIndex = $DT_RowIndex++;
            $row->jenis = $row->jenis;
            $row->nama_kategori = $row->nama_kategori;
            $row->aksi = '<div class="btn-group">
            <button onclick="editForm(`' . base_url('admin/kategori/update/' . $row->id_kategori) . '`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pen"></i></button>
            <a href="' . base_url('admin/kategori/delete/' . $row->id_kategori) . '" onclick="return confirm(\'Yakin hapus data ini?\')" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></a>
        </div>';
            $data[] = $row;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }

    public function update($id)
    {
        if ($this->input->post('post') == 'true' || $this->input->post('post') != null) {
            $data['jenis'] = $this->input->post('jenis');
            $data['slug'] = $this->input->post('slug');
            $data['nama_kategori'] = $this->input->post('nama_kategori');
            $this->db->where('id_kategori', $id);
            $this->db->update('kategori', $data);
            $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di edit',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
            redirect(base_url('admin/kategori'));
        } else {
            $query = $this->db->get_where('kategori', ['id_kategori' => $id])->row_array();
            echo json_encode($query);
        }
    }

    public function add()
    {
        $data['jenis'] = $this->input->post('jenis');
        $data['slug'] = $this->input->post('slug');
        $data['nama_kategori'] = $this->input->post('nama_kategori');

        $this->db->insert('kategori', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/kategori'));
    }

    public function delete($id)
    {
        $this->db->where('id_kategori', $id);
        $this->db->delete('kategori');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/kategori'));
    }
}

/* End of file Kategori.php */
