<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Pembimbing extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        dua();
    }


    public function index()
    {
        $data['title'] = 'Pembimbing';
        admin('pembimbing/index', $data);
    }

    public function data()
    {
        $this->db->select('*');
        $this->db->from('pembimbing_jamaah');
        $this->db->order_by('id_pembimbing', 'desc');
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $row) {
            $cardHtml = '<div class="col-md-4 col-xl-4 col-lg-4">
                            <div class="gal-detail thumb">
                                <a href="' . base_url('public/images/pembimbing/') . $row->images . '" class="image-popup" title="Pembimbing Jamaah">
                                    <img src="'  . base_url('public/images/pembimbing/') . $row->images . '" class="thumb-img img-fluid" alt="work-thumbnail">
                                </a>
                                <p class="text-center">' . $row->nama_pembimbing . '</p>
                                <div class="text-center mt-1">
                                    <a href="' . base_url('admin/pembimbing/delete/') . $row->id_pembimbing . '" onclick="return confirm(\'Yakin Hapus Data ini?\')" class="btn btn-danger btn-block"><i class="fa fa-trash"></i></a>
                                </div>
                            </div>
                        </div>';
            $data[] = $cardHtml;
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'data' => $data,
                'draw' => $this->input->get('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => count($data),
            ]));
    }
    
    public function add()
    {
        $data['nama_pembimbing'] = $this->input->post('nama_pembimbing');

        $config['upload_path'] = './public/images/pembimbing';
        $config['allowed_types'] = 'gif|jpg|png|jpeg|webp';
        $config['overwrite']  = TRUE;
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('images')) {
            $error = array('error' => $this->upload->display_errors());
            print_r($error);
            die;
        } else {
            $data['images'] = $this->upload->data('file_name');
        }
        $this->db->insert('pembimbing_jamaah', $data);
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di tambahkan',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/pembimbing/'));
    }

    public function delete($id)
    {
        $query = $this->db->get_where('pembimbing_jamaah', ['id_pembimbing' => $id])->row();
        @unlink('./public/images/pembimbing/' . $query->images);

        $this->db->where('id_pembimbing', $id);
        $this->db->delete('pembimbing_jamaah');
        $this->session->set_flashdata('pesan', "
            Swal.fire({
                type: 'success',
                title: 'Data Berhasil di hapus',
                text: '',
                showConfirmButton: false,
                timer: 2000
            })
            ");
        redirect(base_url('admin/pembimbing'));
    }
}

/* End of file Pembimbing.php */
