<div class="row">
    <div class="col-12">
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="page-title">Tambahkan Paket</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('admin/paket/') . $jenis_page ?>">Paket <?= ucwords($jenis_page) ?></a></li>
                    <li class="breadcrumb-item active">Tambah</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<form action="<?= base_url('admin/paket/add?jenis=') . $jenis_page ?>" enctype="multipart/form-data" method="post">
    <div class="row">
        <div class="col-md-8">
            <div class="card-box">
                <h4 class="header-title mt-0 mb-3">Data <?= $title ?></h4>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label for="judul_paket">Judul Paket</label>
                        <input type="text" class="form-control judul_paket" maxlength="60" name="judul_paket" id="moreoptions" required />
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="slug">Slug</label>
                        <input type="text" class="form-control" readonly name="slug" id="slug" required />
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="id_kategori">Kategori</label>
                        <select name="id_kategori" id="id_kategori" class="select2" required>
                            <option value="">- Pilih -</option>
                            <?php
                            $kategori = $this->db->get_where('kategori', ['jenis' => ucwords($jenis_page)])->result();
                            foreach ($kategori as $row) :
                            ?>
                                <option value="<?= $row->id_kategori ?>"><?= $row->nama_kategori ?></option>
                            <?php
                            endforeach;
                            ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="program_hari">Program Hari</label>
                        <input type="text" class="form-control" maxlength="20" placeholder="Program 19 Hari" name="program_hari" id="moreoptions" />
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="bandara_keberangkatan">Bandara Keberangkatan</label>
                        <input type="text" class="form-control" maxlength="80" placeholder="" name="bandara_keberangkatan" id="moreoptions" />
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="tanggal_keberangkatan">Tanggal Keberangkatan</label>
                        <input type="date" class="form-control" required placeholder="" name="tanggal_keberangkatan" />
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="seats">Seats</label>
                        <input type="number" class="form-control" placeholder="" name="seats" />
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card-box">
                <h4 class="header-title mt-0 mb-3">Search Engine Optimization</h4>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label for="meta_title">Meta Title</label>
                        <input type="text" class="form-control" maxlength="60" name="meta_title" id="moreoptions" />
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="meta_description">Meta Description</label>
                        <textarea id="textarea" name="meta_description" class="form-control" maxlength="160" rows="9" placeholder=""></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card-box">
                <h4 class="header-title mt-0 mb-3">Detail <?= $title ?></h4>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label for="">Jenis Kamar + Harga</label>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Jenis Kamar</th>
                                    <th>Harga</th>
                                    <th class="text-center"><button type="button" id="add" class="btn btn-primary btn-xs">+</button></th>
                                </tr>
                            </thead>
                            <tbody id="items">
                                <tr>
                                    <td><input type="text" name="jenis_kamar[]" required class="form-control"></td>
                                    <td><input type="text" name="harga[]" data-toggle="input-mask" data-mask-format="000.000.000.000.000" data-reverse="true" required class="form-control"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="fee_agen">Fee Agen</label>
                        <input type="text" class="form-control" name="fee_agen" data-toggle="input-mask" data-mask-format="000.000.000.000.000" data-reverse="true" placeholder="Min : 0" required />
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="">Thumbnail</label>
                        <input type="file" class="dropify" name="thumbnail" />
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="itinerary" class="col-form-label">Itinerary</label>
                        <input type="hidden" name="itinerary">
                        <div id="itinerary" style="height: 150px;" class="itinerary"></div>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="fasilitas" class="col-form-label">Fasilitas</label>
                        <input type="hidden" name="fasilitas">
                        <div id="fasilitas" style="height: 150px;" class="fasilitas"></div>
                    </div>
                    <div class="col-md-12 mb-3">
                        <button class="btn btn-primary btn-block">Submit</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>