<div class="row">
    <div class="col-12">
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="page-title">List Data Pembayaran</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Home</a></li>
                    <li class="breadcrumb-item active">Histori Pembayaran</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card-box">
            <table id="datatable" class="table table-bordered dt-responsive nowrap">
                <thead>
                    <tr>
                        <th>Kode</th>
                        <th>Bank Tujuan</th>
                        <th>Bank Asal</th>
                        <th>Jumlah Pembayaran</th>
                        <th>Waktu Pembayaran</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($pembayaran as $row) :
                        if($row->status == 1){
                            $status = '<span class="badge bg-success">Berhasil</span>';
                        } elseif ($row->status == 2){
                            $status = '<span class="badge bg-danger">Ditolak</span>';
                        }
                    ?>
                        <tr>
                            <td>PMB<?= tambah_nol_didepan($row->id_pembayaran, 5) ?></td>
                            <td>
                                <?= $row->jenis_wallet . ', No : ' . $row->nomor_rekening . ', A/n ' . $row->nama_rekening ?>
                            </td>
                            <td>
                                <?= $row->bank_asal . ', No : ' . $row->no_rekening_asal . ', A/n ' . $row->nama_rekening_asal ?>
                            </td>
                            <td>Rp. <?= number_format($row->jumlah_pembayaran, 0, '.', '.') ?></td>
                            <td><?= format_indo($row->waktu_pembayaran) ?></td>
                            <td><?= $status ?></td>
                        </tr>
                    <?php
                    endforeach;
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div id="modal-form" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel"></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <form method="POST">
                <div class="modal-body" id="detailnya">
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light waves-effect" data-dismiss="modal">Tutup</button>
                    <input type="hidden" name="post" value="true">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>