<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">


    <title>Rekap Pembayaran</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://netdna.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet">

    <style type="text/css">
        @import url("https://netdna.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css");

        body {
            background: #eee;
            margin-top: 20px;
        }

        .text-danger strong {
            color: #9f181c;
        }

        .receipt-main {
            background: #ffffff none repeat scroll 0 0;
            border-bottom: 12px solid #333333;
            border-top: 12px solid #9f181c;
            margin-top: 50px;
            margin-bottom: 50px;
            padding: 40px 30px !important;
            position: relative;
            box-shadow: 0 1px 21px #acacac;
            color: #333333;
            font-family: open sans;
        }

        .receipt-main p {
            color: #333333;
            font-family: open sans;
            line-height: 1.42857;
        }

        .receipt-footer h1 {
            font-size: 15px;
            font-weight: 400 !important;
            margin: 0 !important;
        }

        .receipt-main::after {
            background: #414143 none repeat scroll 0 0;
            content: "";
            height: 5px;
            left: 0;
            position: absolute;
            right: 0;
            top: -13px;
        }

        .receipt-main thead {
            background: #414143 none repeat scroll 0 0;
        }

        .receipt-main thead th {
            color: #fff;
        }

        .receipt-right h5 {
            font-size: 16px;
            font-weight: bold;
            margin: 0 0 7px 0;
        }

        .receipt-right p {
            font-size: 12px;
            margin: 0px;
        }

        .receipt-right p i {
            text-align: center;
            width: 18px;
        }

        .receipt-main td {
            padding: 9px 20px !important;
        }

        .receipt-main th {
            padding: 13px 20px !important;
        }

        .receipt-main td {
            font-size: 13px;
            font-weight: initial !important;
        }

        .receipt-main td p:last-child {
            margin: 0;
            padding: 0;
        }

        .receipt-main td h2 {
            font-size: 20px;
            font-weight: 900;
            margin: 0;
            text-transform: uppercase;
        }

        .receipt-header-mid .receipt-left h1 {
            font-weight: 100;
            margin: 34px 0 0;
            text-align: right;
            text-transform: uppercase;
        }

        .receipt-header-mid {
            margin: 24px 0;
            overflow: hidden;
        }

        #container {
            background-color: #dcdcdc;
        }
    </style>

</head>

<body>
    <div class="col-md-12">
        <div class="row">
            <div class="receipt-main col-xs-10 col-sm-10 col-md-6 col-xs-offset-1 col-sm-offset-1 col-md-offset-3">

                <div class="row">
                    <div class="receipt-header">
                        <div class="col-xs-6 col-sm-6 col-md-6">
                            <div class="receipt-left">
                                <img class="img-responsive" alt="iamgurdeeposahan" src="https://bootdey.com/img/Content/avatar/avatar6.png" style="width: 71px; border-radius: 43px;">
                            </div>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-6 text-right">
                            <div class="receipt-right">
                                <h5>HIT Travel.</h5>
                                <p>+62 831-9336-9236 <i class="fa fa-phone"></i></p>
                                <p><a class="__cf_email__" data-cfemail="bad9d5d7cadbd4c3faddd7dbd3d694d9d5d7">admin@purogurama.com</a> <i class="fa fa-envelope-o"></i></p>
                                <p>Indonesia <i class="fa fa-location-arrow"></i></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="receipt-header receipt-header-mid">
                        <div class="col-xs-8 col-sm-8 col-md-8 text-left">
                            <div class="receipt-right">
                                <h5><?= $users->nama ?></h5>
                                <p><b>WhatsApp :</b> <?= $users->whatsapp ?></p>
                                <p><b>Email :</b> <a class="__cf_email__" data-cfemail="b9dacccacdd6d4dccbf9ded4d8d0d597dad6d4"><?= $users->alamat_email ?></a></p>
                                <p><b>Indonesia</p>
                            </div>
                        </div>
                        <div class="col-xs-4 col-sm-4 col-md-4">
                            <div class="receipt-left">
                                <h3>INVOICE # <?= tambah_nol_didepan($booking->id_booking, 4) ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Tanggal Waktu</th>
                                <th>Description</th>
                                <th>Nominal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $total = 0;
                            foreach ($pembayaran as $row) :
                                $total += $row->jumlah_pembayaran;
                            ?>
                                <tr>
                                    <td class="col-md-9"><?= format_indo($row->waktu_pembayaran) ?></td>
                                    <td>
                                        <?php
                                        $kode_transaksi = $this->uri->segment(4);
                                        if ($row->distribusi_pembayaran == 0) {
                                        ?>
                                            Dibagi Merata
                                            <?php
                                        } else {
                                            $idJmh = explode('|', $row->id_data_booking);
                                            $noms = explode('|', $row->nominal_distribusi);
                                            foreach ($idJmh as $keys => $idNya) {
                                                $getDataBooking = $this->db->query("SELECT nama_jamaah FROM data_booking WHERE id_data_booking = '$idNya'")->row();
                                            ?>
                                                <p><?= $getDataBooking->nama_jamaah ?> : <br> Rp. <?= number_format($noms[$keys], 0, '.', '.') ?></p>
                                        <?php
                                            }
                                        }
                                        ?>
                                    </td>
                                    <td class="col-md-3"><i class="fa fa-inr"></i> Rp. <?= number_format($row->jumlah_pembayaran, 0, '.', '.') ?></td>
                                </tr>
                            <?php
                            endforeach;
                            ?>
                            <tr>
                                <td class="text-right" colspan="2">
                                    <h2><strong>Total: </strong></h2>
                                </td>
                                <td class="text-left text-danger">
                                    <h2><strong><i class="fa fa-inr"></i> Rp. <?= number_format($total, 0, '.', '.') ?></strong></h2>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="row">
                    <div class="receipt-header receipt-header-mid receipt-footer">
                        <div class="col-xs-8 col-sm-8 col-md-8 text-left">
                            <div class="receipt-right">
                                <p><b>Date :</b> <?= format_indo(date("Y-m-d")) ?></p>
                                <h5 style="color: rgb(140, 140, 140);">Thanks for payment.!</h5>
                            </div>
                        </div>
                        <div class="col-xs-4 col-sm-4 col-md-4">
                            <div class="receipt-left">
                                <h1>Stamp</h1>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="https://code.jquery.com/jquery-1.10.2.min.js"></script>
    <script src="https://netdna.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <script type="text/javascript">
        window.onafterprint = window.close;
        window.print();
    </script>
</body>

</html>